package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{S3Uri, ContentDigest, ContentType}
import scala.jdk.CollectionConverters._
final case class FileSource(
    contentType: Option[ContentType] = None,
    contentDigest: Option[ContentDigest] = None,
    s3Uri: S3Uri
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FileSource = {
    import FileSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FileSource
      .builder()
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        contentDigest.map(value =>
          ContentDigest.unwrap(value): java.lang.String
        )
      )(_.contentDigest)
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.FileSource.ReadOnly =
    zio.aws.sagemaker.model.FileSource.wrap(buildAwsValue())
}
object FileSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FileSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FileSource =
      zio.aws.sagemaker.model.FileSource(
        contentType.map(value => value),
        contentDigest.map(value => value),
        s3Uri
      )
    def contentType: Option[ContentType]
    def contentDigest: Option[ContentDigest]
    def s3Uri: S3Uri
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getContentDigest: ZIO[Any, AwsError, ContentDigest] =
      AwsError.unwrapOptionField("contentDigest", contentDigest)
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FileSource
  ) extends zio.aws.sagemaker.model.FileSource.ReadOnly {
    override val contentType: Option[ContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.sagemaker.model.primitives.ContentType(value))
    override val contentDigest: Option[ContentDigest] = scala
      .Option(impl.contentDigest())
      .map(value => zio.aws.sagemaker.model.primitives.ContentDigest(value))
    override val s3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3Uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FileSource
  ): zio.aws.sagemaker.model.FileSource.ReadOnly = new Wrapper(impl)
}
