package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  ProcessingJobArn,
  ProcessingEnvironmentValue,
  Timestamp,
  FailureReason,
  ProcessingEnvironmentKey,
  TrainingJobArn,
  ExitMessage,
  MonitoringScheduleArn,
  ProcessingJobName,
  AutoMLJobArn
}
import scala.jdk.CollectionConverters._
final case class DescribeProcessingJobResponse(
    processingInputs: Option[
      Iterable[zio.aws.sagemaker.model.ProcessingInput]
    ] = None,
    processingOutputConfig: Option[
      zio.aws.sagemaker.model.ProcessingOutputConfig
    ] = None,
    processingJobName: ProcessingJobName,
    processingResources: zio.aws.sagemaker.model.ProcessingResources,
    stoppingCondition: Option[
      zio.aws.sagemaker.model.ProcessingStoppingCondition
    ] = None,
    appSpecification: zio.aws.sagemaker.model.AppSpecification,
    environment: Option[
      Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]
    ] = None,
    networkConfig: Option[zio.aws.sagemaker.model.NetworkConfig] = None,
    roleArn: Option[RoleArn] = None,
    experimentConfig: Option[zio.aws.sagemaker.model.ExperimentConfig] = None,
    processingJobArn: ProcessingJobArn,
    processingJobStatus: zio.aws.sagemaker.model.ProcessingJobStatus,
    exitMessage: Option[ExitMessage] = None,
    failureReason: Option[FailureReason] = None,
    processingEndTime: Option[Timestamp] = None,
    processingStartTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    creationTime: Timestamp,
    monitoringScheduleArn: Option[MonitoringScheduleArn] = None,
    autoMLJobArn: Option[AutoMLJobArn] = None,
    trainingJobArn: Option[TrainingJobArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobResponse = {
    import DescribeProcessingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobResponse
      .builder()
      .optionallyWith(
        processingInputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processingInputs)
      .optionallyWith(
        processingOutputConfig.map(value => value.buildAwsValue())
      )(_.processingOutputConfig)
      .processingJobName(
        ProcessingJobName.unwrap(processingJobName): java.lang.String
      )
      .processingResources(processingResources.buildAwsValue())
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .appSpecification(appSpecification.buildAwsValue())
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (ProcessingEnvironmentKey.unwrap(
                key
              ): java.lang.String) -> (ProcessingEnvironmentValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(networkConfig.map(value => value.buildAwsValue()))(
        _.networkConfig
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(experimentConfig.map(value => value.buildAwsValue()))(
        _.experimentConfig
      )
      .processingJobArn(
        ProcessingJobArn.unwrap(processingJobArn): java.lang.String
      )
      .processingJobStatus(processingJobStatus.unwrap)
      .optionallyWith(
        exitMessage.map(value => ExitMessage.unwrap(value): java.lang.String)
      )(_.exitMessage)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        processingEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.processingEndTime)
      .optionallyWith(
        processingStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.processingStartTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        monitoringScheduleArn.map(value =>
          MonitoringScheduleArn.unwrap(value): java.lang.String
        )
      )(_.monitoringScheduleArn)
      .optionallyWith(
        autoMLJobArn.map(value => AutoMLJobArn.unwrap(value): java.lang.String)
      )(_.autoMLJobArn)
      .optionallyWith(
        trainingJobArn.map(value =>
          TrainingJobArn.unwrap(value): java.lang.String
        )
      )(_.trainingJobArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeProcessingJobResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeProcessingJobResponse.wrap(buildAwsValue())
}
object DescribeProcessingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeProcessingJobResponse =
      zio.aws.sagemaker.model.DescribeProcessingJobResponse(
        processingInputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processingOutputConfig.map(value => value.asEditable),
        processingJobName,
        processingResources.asEditable,
        stoppingCondition.map(value => value.asEditable),
        appSpecification.asEditable,
        environment.map(value => value),
        networkConfig.map(value => value.asEditable),
        roleArn.map(value => value),
        experimentConfig.map(value => value.asEditable),
        processingJobArn,
        processingJobStatus,
        exitMessage.map(value => value),
        failureReason.map(value => value),
        processingEndTime.map(value => value),
        processingStartTime.map(value => value),
        lastModifiedTime.map(value => value),
        creationTime,
        monitoringScheduleArn.map(value => value),
        autoMLJobArn.map(value => value),
        trainingJobArn.map(value => value)
      )
    def processingInputs
        : Option[List[zio.aws.sagemaker.model.ProcessingInput.ReadOnly]]
    def processingOutputConfig
        : Option[zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly]
    def processingJobName: ProcessingJobName
    def processingResources
        : zio.aws.sagemaker.model.ProcessingResources.ReadOnly
    def stoppingCondition
        : Option[zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly]
    def appSpecification: zio.aws.sagemaker.model.AppSpecification.ReadOnly
    def environment
        : Option[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]]
    def networkConfig: Option[zio.aws.sagemaker.model.NetworkConfig.ReadOnly]
    def roleArn: Option[RoleArn]
    def experimentConfig
        : Option[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly]
    def processingJobArn: ProcessingJobArn
    def processingJobStatus: zio.aws.sagemaker.model.ProcessingJobStatus
    def exitMessage: Option[ExitMessage]
    def failureReason: Option[FailureReason]
    def processingEndTime: Option[Timestamp]
    def processingStartTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def creationTime: Timestamp
    def monitoringScheduleArn: Option[MonitoringScheduleArn]
    def autoMLJobArn: Option[AutoMLJobArn]
    def trainingJobArn: Option[TrainingJobArn]
    def getProcessingInputs: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProcessingInput.ReadOnly
    ]] = AwsError.unwrapOptionField("processingInputs", processingInputs)
    def getProcessingOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingOutputConfig",
      processingOutputConfig
    )
    def getProcessingJobName: ZIO[Any, Nothing, ProcessingJobName] =
      ZIO.succeed(processingJobName)
    def getProcessingResources: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ProcessingResources.ReadOnly
    ] = ZIO.succeed(processingResources)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
    def getAppSpecification
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AppSpecification.ReadOnly] =
      ZIO.succeed(appSpecification)
    def getEnvironment: ZIO[Any, AwsError, Map[
      ProcessingEnvironmentKey,
      ProcessingEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
    def getNetworkConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NetworkConfig.ReadOnly] =
      AwsError.unwrapOptionField("networkConfig", networkConfig)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getExperimentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExperimentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("experimentConfig", experimentConfig)
    def getProcessingJobArn: ZIO[Any, Nothing, ProcessingJobArn] =
      ZIO.succeed(processingJobArn)
    def getProcessingJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ProcessingJobStatus] =
      ZIO.succeed(processingJobStatus)
    def getExitMessage: ZIO[Any, AwsError, ExitMessage] =
      AwsError.unwrapOptionField("exitMessage", exitMessage)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getProcessingEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("processingEndTime", processingEndTime)
    def getProcessingStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("processingStartTime", processingStartTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getMonitoringScheduleArn: ZIO[Any, AwsError, MonitoringScheduleArn] =
      AwsError.unwrapOptionField("monitoringScheduleArn", monitoringScheduleArn)
    def getAutoMLJobArn: ZIO[Any, AwsError, AutoMLJobArn] =
      AwsError.unwrapOptionField("autoMLJobArn", autoMLJobArn)
    def getTrainingJobArn: ZIO[Any, AwsError, TrainingJobArn] =
      AwsError.unwrapOptionField("trainingJobArn", trainingJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobResponse
  ) extends zio.aws.sagemaker.model.DescribeProcessingJobResponse.ReadOnly {
    override val processingInputs
        : Option[List[zio.aws.sagemaker.model.ProcessingInput.ReadOnly]] = scala
      .Option(impl.processingInputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProcessingInput.wrap(item)
        }.toList
      )
    override val processingOutputConfig
        : Option[zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly] =
      scala
        .Option(impl.processingOutputConfig())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingOutputConfig.wrap(value)
        )
    override val processingJobName: ProcessingJobName =
      zio.aws.sagemaker.model.primitives
        .ProcessingJobName(impl.processingJobName())
    override val processingResources
        : zio.aws.sagemaker.model.ProcessingResources.ReadOnly =
      zio.aws.sagemaker.model.ProcessingResources
        .wrap(impl.processingResources())
    override val stoppingCondition
        : Option[zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly] =
      scala
        .Option(impl.stoppingCondition())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingStoppingCondition.wrap(value)
        )
    override val appSpecification
        : zio.aws.sagemaker.model.AppSpecification.ReadOnly =
      zio.aws.sagemaker.model.AppSpecification.wrap(impl.appSpecification())
    override val environment
        : Option[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]] =
      scala
        .Option(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.ProcessingEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .ProcessingEnvironmentValue(value)
            })
            .toMap
        )
    override val networkConfig
        : Option[zio.aws.sagemaker.model.NetworkConfig.ReadOnly] = scala
      .Option(impl.networkConfig())
      .map(value => zio.aws.sagemaker.model.NetworkConfig.wrap(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val experimentConfig
        : Option[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly] = scala
      .Option(impl.experimentConfig())
      .map(value => zio.aws.sagemaker.model.ExperimentConfig.wrap(value))
    override val processingJobArn: ProcessingJobArn =
      zio.aws.sagemaker.model.primitives
        .ProcessingJobArn(impl.processingJobArn())
    override val processingJobStatus
        : zio.aws.sagemaker.model.ProcessingJobStatus =
      zio.aws.sagemaker.model.ProcessingJobStatus
        .wrap(impl.processingJobStatus())
    override val exitMessage: Option[ExitMessage] = scala
      .Option(impl.exitMessage())
      .map(value => zio.aws.sagemaker.model.primitives.ExitMessage(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val processingEndTime: Option[Timestamp] = scala
      .Option(impl.processingEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val processingStartTime: Option[Timestamp] = scala
      .Option(impl.processingStartTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val monitoringScheduleArn: Option[MonitoringScheduleArn] = scala
      .Option(impl.monitoringScheduleArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MonitoringScheduleArn(value)
      )
    override val autoMLJobArn: Option[AutoMLJobArn] = scala
      .Option(impl.autoMLJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.AutoMLJobArn(value))
    override val trainingJobArn: Option[TrainingJobArn] = scala
      .Option(impl.trainingJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrainingJobArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobResponse
  ): zio.aws.sagemaker.model.DescribeProcessingJobResponse.ReadOnly =
    new Wrapper(impl)
}
