package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ImageName
import scala.jdk.CollectionConverters._
final case class DescribeImageRequest(imageName: ImageName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest = {
    import DescribeImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest
      .builder()
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeImageRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeImageRequest.wrap(buildAwsValue())
}
object DescribeImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeImageRequest =
      zio.aws.sagemaker.model.DescribeImageRequest(imageName)
    def imageName: ImageName
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest
  ) extends zio.aws.sagemaker.model.DescribeImageRequest.ReadOnly {
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest
  ): zio.aws.sagemaker.model.DescribeImageRequest.ReadOnly = new Wrapper(impl)
}
