package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  DeviceArn,
  ThingName,
  EdgeVersion,
  DeviceDescription,
  Timestamp,
  Integer,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class DescribeDeviceResponse(
    deviceArn: Option[DeviceArn] = None,
    deviceName: EntityName,
    description: Option[DeviceDescription] = None,
    deviceFleetName: EntityName,
    iotThingName: Option[ThingName] = None,
    registrationTime: Timestamp,
    latestHeartbeat: Option[Timestamp] = None,
    models: Option[Iterable[zio.aws.sagemaker.model.EdgeModel]] = None,
    maxModels: Option[Integer] = None,
    nextToken: Option[NextToken] = None,
    agentVersion: Option[EdgeVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse = {
    import DescribeDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse
      .builder()
      .optionallyWith(
        deviceArn.map(value => DeviceArn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .deviceName(EntityName.unwrap(deviceName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DeviceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .optionallyWith(
        iotThingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.iotThingName)
      .registrationTime(Timestamp.unwrap(registrationTime): Instant)
      .optionallyWith(
        latestHeartbeat.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestHeartbeat)
      .optionallyWith(
        models.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.models)
      .optionallyWith(
        maxModels.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxModels)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        agentVersion.map(value => EdgeVersion.unwrap(value): java.lang.String)
      )(_.agentVersion)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeDeviceResponse.wrap(buildAwsValue())
}
object DescribeDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeDeviceResponse =
      zio.aws.sagemaker.model.DescribeDeviceResponse(
        deviceArn.map(value => value),
        deviceName,
        description.map(value => value),
        deviceFleetName,
        iotThingName.map(value => value),
        registrationTime,
        latestHeartbeat.map(value => value),
        models.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxModels.map(value => value),
        nextToken.map(value => value),
        agentVersion.map(value => value)
      )
    def deviceArn: Option[DeviceArn]
    def deviceName: EntityName
    def description: Option[DeviceDescription]
    def deviceFleetName: EntityName
    def iotThingName: Option[ThingName]
    def registrationTime: Timestamp
    def latestHeartbeat: Option[Timestamp]
    def models: Option[List[zio.aws.sagemaker.model.EdgeModel.ReadOnly]]
    def maxModels: Option[Integer]
    def nextToken: Option[NextToken]
    def agentVersion: Option[EdgeVersion]
    def getDeviceArn: ZIO[Any, AwsError, DeviceArn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
    def getDeviceName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(deviceName)
    def getDescription: ZIO[Any, AwsError, DeviceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
    def getIotThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("iotThingName", iotThingName)
    def getRegistrationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(registrationTime)
    def getLatestHeartbeat: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestHeartbeat", latestHeartbeat)
    def getModels
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.EdgeModel.ReadOnly]] =
      AwsError.unwrapOptionField("models", models)
    def getMaxModels: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxModels", maxModels)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAgentVersion: ZIO[Any, AwsError, EdgeVersion] =
      AwsError.unwrapOptionField("agentVersion", agentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse
  ) extends zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly {
    override val deviceArn: Option[DeviceArn] = scala
      .Option(impl.deviceArn())
      .map(value => zio.aws.sagemaker.model.primitives.DeviceArn(value))
    override val deviceName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceName())
    override val description: Option[DeviceDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.DeviceDescription(value))
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
    override val iotThingName: Option[ThingName] = scala
      .Option(impl.iotThingName())
      .map(value => zio.aws.sagemaker.model.primitives.ThingName(value))
    override val registrationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.registrationTime())
    override val latestHeartbeat: Option[Timestamp] = scala
      .Option(impl.latestHeartbeat())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val models
        : Option[List[zio.aws.sagemaker.model.EdgeModel.ReadOnly]] = scala
      .Option(impl.models())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.EdgeModel.wrap(item)
        }.toList
      )
    override val maxModels: Option[Integer] = scala
      .Option(impl.maxModels())
      .map(value => zio.aws.sagemaker.model.primitives.Integer(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val agentVersion: Option[EdgeVersion] = scala
      .Option(impl.agentVersion())
      .map(value => zio.aws.sagemaker.model.primitives.EdgeVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse
  ): zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly = new Wrapper(impl)
}
