package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  AppArn,
  Timestamp,
  FailureReason,
  DomainId,
  AppName,
  UserProfileName
}
import scala.jdk.CollectionConverters._
final case class DescribeAppResponse(
    appArn: Option[AppArn] = None,
    appType: Option[zio.aws.sagemaker.model.AppType] = None,
    appName: Option[AppName] = None,
    domainId: Option[DomainId] = None,
    userProfileName: Option[UserProfileName] = None,
    status: Option[zio.aws.sagemaker.model.AppStatus] = None,
    lastHealthCheckTimestamp: Option[Timestamp] = None,
    lastUserActivityTimestamp: Option[Timestamp] = None,
    creationTime: Option[CreationTime] = None,
    failureReason: Option[FailureReason] = None,
    resourceSpec: Option[zio.aws.sagemaker.model.ResourceSpec] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse = {
    import DescribeAppResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse
      .builder()
      .optionallyWith(
        appArn.map(value => AppArn.unwrap(value): java.lang.String)
      )(_.appArn)
      .optionallyWith(appType.map(value => value.unwrap))(_.appType)
      .optionallyWith(
        appName.map(value => AppName.unwrap(value): java.lang.String)
      )(_.appName)
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        userProfileName.map(value =>
          UserProfileName.unwrap(value): java.lang.String
        )
      )(_.userProfileName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastHealthCheckTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastHealthCheckTimestamp)
      .optionallyWith(
        lastUserActivityTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUserActivityTimestamp)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(resourceSpec.map(value => value.buildAwsValue()))(
        _.resourceSpec
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeAppResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeAppResponse.wrap(buildAwsValue())
}
object DescribeAppResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeAppResponse =
      zio.aws.sagemaker.model.DescribeAppResponse(
        appArn.map(value => value),
        appType.map(value => value),
        appName.map(value => value),
        domainId.map(value => value),
        userProfileName.map(value => value),
        status.map(value => value),
        lastHealthCheckTimestamp.map(value => value),
        lastUserActivityTimestamp.map(value => value),
        creationTime.map(value => value),
        failureReason.map(value => value),
        resourceSpec.map(value => value.asEditable)
      )
    def appArn: Option[AppArn]
    def appType: Option[zio.aws.sagemaker.model.AppType]
    def appName: Option[AppName]
    def domainId: Option[DomainId]
    def userProfileName: Option[UserProfileName]
    def status: Option[zio.aws.sagemaker.model.AppStatus]
    def lastHealthCheckTimestamp: Option[Timestamp]
    def lastUserActivityTimestamp: Option[Timestamp]
    def creationTime: Option[CreationTime]
    def failureReason: Option[FailureReason]
    def resourceSpec: Option[zio.aws.sagemaker.model.ResourceSpec.ReadOnly]
    def getAppArn: ZIO[Any, AwsError, AppArn] =
      AwsError.unwrapOptionField("appArn", appArn)
    def getAppType: ZIO[Any, AwsError, zio.aws.sagemaker.model.AppType] =
      AwsError.unwrapOptionField("appType", appType)
    def getAppName: ZIO[Any, AwsError, AppName] =
      AwsError.unwrapOptionField("appName", appName)
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getUserProfileName: ZIO[Any, AwsError, UserProfileName] =
      AwsError.unwrapOptionField("userProfileName", userProfileName)
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.AppStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastHealthCheckTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastHealthCheckTimestamp", lastHealthCheckTimestamp)
    def getLastUserActivityTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastUserActivityTimestamp", lastUserActivityTimestamp)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getResourceSpec
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      AwsError.unwrapOptionField("resourceSpec", resourceSpec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse
  ) extends zio.aws.sagemaker.model.DescribeAppResponse.ReadOnly {
    override val appArn: Option[AppArn] = scala
      .Option(impl.appArn())
      .map(value => zio.aws.sagemaker.model.primitives.AppArn(value))
    override val appType: Option[zio.aws.sagemaker.model.AppType] = scala
      .Option(impl.appType())
      .map(value => zio.aws.sagemaker.model.AppType.wrap(value))
    override val appName: Option[AppName] = scala
      .Option(impl.appName())
      .map(value => zio.aws.sagemaker.model.primitives.AppName(value))
    override val domainId: Option[DomainId] = scala
      .Option(impl.domainId())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val userProfileName: Option[UserProfileName] = scala
      .Option(impl.userProfileName())
      .map(value => zio.aws.sagemaker.model.primitives.UserProfileName(value))
    override val status: Option[zio.aws.sagemaker.model.AppStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.sagemaker.model.AppStatus.wrap(value))
    override val lastHealthCheckTimestamp: Option[Timestamp] = scala
      .Option(impl.lastHealthCheckTimestamp())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastUserActivityTimestamp: Option[Timestamp] = scala
      .Option(impl.lastUserActivityTimestamp())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val resourceSpec
        : Option[zio.aws.sagemaker.model.ResourceSpec.ReadOnly] = scala
      .Option(impl.resourceSpec())
      .map(value => zio.aws.sagemaker.model.ResourceSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse
  ): zio.aws.sagemaker.model.DescribeAppResponse.ReadOnly = new Wrapper(impl)
}
