package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ImageVersionArn
import scala.jdk.CollectionConverters._
final case class CreateImageVersionResponse(
    imageVersionArn: Option[ImageVersionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateImageVersionResponse = {
    import CreateImageVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateImageVersionResponse
      .builder()
      .optionallyWith(
        imageVersionArn.map(value =>
          ImageVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateImageVersionResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateImageVersionResponse.wrap(buildAwsValue())
}
object CreateImageVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateImageVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateImageVersionResponse =
      zio.aws.sagemaker.model
        .CreateImageVersionResponse(imageVersionArn.map(value => value))
    def imageVersionArn: Option[ImageVersionArn]
    def getImageVersionArn: ZIO[Any, AwsError, ImageVersionArn] =
      AwsError.unwrapOptionField("imageVersionArn", imageVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateImageVersionResponse
  ) extends zio.aws.sagemaker.model.CreateImageVersionResponse.ReadOnly {
    override val imageVersionArn: Option[ImageVersionArn] = scala
      .Option(impl.imageVersionArn())
      .map(value => zio.aws.sagemaker.model.primitives.ImageVersionArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateImageVersionResponse
  ): zio.aws.sagemaker.model.CreateImageVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
