package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait CandidateStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.CandidateStatus
}
object CandidateStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.CandidateStatus
  ): zio.aws.sagemaker.model.CandidateStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.CandidateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.CandidateStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.CandidateStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.CandidateStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.CandidateStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.sagemaker.model.CandidateStatus.STOPPING =>
      val r = Stopping
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.CandidateStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateStatus =
      software.amazon.awssdk.services.sagemaker.model.CandidateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Completed extends zio.aws.sagemaker.model.CandidateStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateStatus =
      software.amazon.awssdk.services.sagemaker.model.CandidateStatus.COMPLETED
  }
  case object InProgress extends zio.aws.sagemaker.model.CandidateStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateStatus =
      software.amazon.awssdk.services.sagemaker.model.CandidateStatus.IN_PROGRESS
  }
  case object Failed extends zio.aws.sagemaker.model.CandidateStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateStatus =
      software.amazon.awssdk.services.sagemaker.model.CandidateStatus.FAILED
  }
  case object Stopped extends zio.aws.sagemaker.model.CandidateStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateStatus =
      software.amazon.awssdk.services.sagemaker.model.CandidateStatus.STOPPED
  }
  case object Stopping extends zio.aws.sagemaker.model.CandidateStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateStatus =
      software.amazon.awssdk.services.sagemaker.model.CandidateStatus.STOPPING
  }
}
