package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExplainabilityLocation
import scala.jdk.CollectionConverters._
final case class CandidateArtifactLocations(
    explainability: ExplainabilityLocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CandidateArtifactLocations = {
    import CandidateArtifactLocations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CandidateArtifactLocations
      .builder()
      .explainability(
        ExplainabilityLocation.unwrap(explainability): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CandidateArtifactLocations.ReadOnly =
    zio.aws.sagemaker.model.CandidateArtifactLocations.wrap(buildAwsValue())
}
object CandidateArtifactLocations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CandidateArtifactLocations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CandidateArtifactLocations =
      zio.aws.sagemaker.model.CandidateArtifactLocations(explainability)
    def explainability: ExplainabilityLocation
    def getExplainability: ZIO[Any, Nothing, ExplainabilityLocation] =
      ZIO.succeed(explainability)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CandidateArtifactLocations
  ) extends zio.aws.sagemaker.model.CandidateArtifactLocations.ReadOnly {
    override val explainability: ExplainabilityLocation =
      zio.aws.sagemaker.model.primitives
        .ExplainabilityLocation(impl.explainability())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CandidateArtifactLocations
  ): zio.aws.sagemaker.model.CandidateArtifactLocations.ReadOnly = new Wrapper(
    impl
  )
}
