package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.TrainingJobName
import scala.jdk.CollectionConverters._
final case class UpdateTrainingJobRequest(
    trainingJobName: TrainingJobName,
    profilerConfig: Option[zio.aws.sagemaker.model.ProfilerConfigForUpdate] =
      None,
    profilerRuleConfigurations: Option[
      Iterable[zio.aws.sagemaker.model.ProfilerRuleConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest = {
    import UpdateTrainingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest
      .builder()
      .trainingJobName(
        TrainingJobName.unwrap(trainingJobName): java.lang.String
      )
      .optionallyWith(profilerConfig.map(value => value.buildAwsValue()))(
        _.profilerConfig
      )
      .optionallyWith(
        profilerRuleConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.profilerRuleConfigurations)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateTrainingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateTrainingJobRequest.wrap(buildAwsValue())
}
object UpdateTrainingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateTrainingJobRequest =
      zio.aws.sagemaker.model.UpdateTrainingJobRequest(
        trainingJobName,
        profilerConfig.map(value => value.asEditable),
        profilerRuleConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trainingJobName: TrainingJobName
    def profilerConfig
        : Option[zio.aws.sagemaker.model.ProfilerConfigForUpdate.ReadOnly]
    def profilerRuleConfigurations: Option[
      List[zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly]
    ]
    def getTrainingJobName: ZIO[Any, Nothing, TrainingJobName] =
      ZIO.succeed(trainingJobName)
    def getProfilerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProfilerConfigForUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("profilerConfig", profilerConfig)
    def getProfilerRuleConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "profilerRuleConfigurations",
      profilerRuleConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest
  ) extends zio.aws.sagemaker.model.UpdateTrainingJobRequest.ReadOnly {
    override val trainingJobName: TrainingJobName =
      zio.aws.sagemaker.model.primitives.TrainingJobName(impl.trainingJobName())
    override val profilerConfig
        : Option[zio.aws.sagemaker.model.ProfilerConfigForUpdate.ReadOnly] =
      scala
        .Option(impl.profilerConfig())
        .map(value =>
          zio.aws.sagemaker.model.ProfilerConfigForUpdate.wrap(value)
        )
    override val profilerRuleConfigurations: Option[
      List[zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly]
    ] = scala
      .Option(impl.profilerRuleConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProfilerRuleConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest
  ): zio.aws.sagemaker.model.UpdateTrainingJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
