package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.HyperParameterTuningJobArn
import scala.jdk.CollectionConverters._
final case class TuningJobStepMetaData(
    arn: Option[HyperParameterTuningJobArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TuningJobStepMetaData = {
    import TuningJobStepMetaData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TuningJobStepMetaData
      .builder()
      .optionallyWith(
        arn.map(value =>
          HyperParameterTuningJobArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TuningJobStepMetaData.ReadOnly =
    zio.aws.sagemaker.model.TuningJobStepMetaData.wrap(buildAwsValue())
}
object TuningJobStepMetaData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TuningJobStepMetaData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TuningJobStepMetaData =
      zio.aws.sagemaker.model.TuningJobStepMetaData(arn.map(value => value))
    def arn: Option[HyperParameterTuningJobArn]
    def getArn: ZIO[Any, AwsError, HyperParameterTuningJobArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TuningJobStepMetaData
  ) extends zio.aws.sagemaker.model.TuningJobStepMetaData.ReadOnly {
    override val arn: Option[HyperParameterTuningJobArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.HyperParameterTuningJobArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TuningJobStepMetaData
  ): zio.aws.sagemaker.model.TuningJobStepMetaData.ReadOnly = new Wrapper(impl)
}
