package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  DoubleParameterValue,
  StringParameterValue
}
import scala.jdk.CollectionConverters._
final case class TrialComponentParameterValue(
    stringValue: Option[StringParameterValue] = None,
    numberValue: Option[DoubleParameterValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialComponentParameterValue = {
    import TrialComponentParameterValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialComponentParameterValue
      .builder()
      .optionallyWith(
        stringValue.map(value =>
          StringParameterValue.unwrap(value): java.lang.String
        )
      )(_.stringValue)
      .optionallyWith(
        numberValue.map(value =>
          DoubleParameterValue.unwrap(value): java.lang.Double
        )
      )(_.numberValue)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly =
    zio.aws.sagemaker.model.TrialComponentParameterValue.wrap(buildAwsValue())
}
object TrialComponentParameterValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialComponentParameterValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialComponentParameterValue =
      zio.aws.sagemaker.model.TrialComponentParameterValue(
        stringValue.map(value => value),
        numberValue.map(value => value)
      )
    def stringValue: Option[StringParameterValue]
    def numberValue: Option[DoubleParameterValue]
    def getStringValue: ZIO[Any, AwsError, StringParameterValue] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getNumberValue: ZIO[Any, AwsError, DoubleParameterValue] =
      AwsError.unwrapOptionField("numberValue", numberValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentParameterValue
  ) extends zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly {
    override val stringValue: Option[StringParameterValue] = scala
      .Option(impl.stringValue())
      .map(value =>
        zio.aws.sagemaker.model.primitives.StringParameterValue(value)
      )
    override val numberValue: Option[DoubleParameterValue] = scala
      .Option(impl.numberValue())
      .map(value =>
        zio.aws.sagemaker.model.primitives.DoubleParameterValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentParameterValue
  ): zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly =
    new Wrapper(impl)
}
