package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait TargetPlatformOs {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.TargetPlatformOs
}
object TargetPlatformOs {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TargetPlatformOs
  ): zio.aws.sagemaker.model.TargetPlatformOs = value match {
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformOs.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformOs.ANDROID =>
      val r = ANDROID
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformOs.LINUX =>
      val r = LINUX
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.TargetPlatformOs {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformOs =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformOs.UNKNOWN_TO_SDK_VERSION
  }
  case object ANDROID extends zio.aws.sagemaker.model.TargetPlatformOs {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformOs =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformOs.ANDROID
  }
  case object LINUX extends zio.aws.sagemaker.model.TargetPlatformOs {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformOs =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformOs.LINUX
  }
}
