package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.TaskInput
import scala.jdk.CollectionConverters._
final case class RenderableTask(input: TaskInput) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RenderableTask = {
    import RenderableTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RenderableTask
      .builder()
      .input(TaskInput.unwrap(input): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RenderableTask.ReadOnly =
    zio.aws.sagemaker.model.RenderableTask.wrap(buildAwsValue())
}
object RenderableTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RenderableTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RenderableTask =
      zio.aws.sagemaker.model.RenderableTask(input)
    def input: TaskInput
    def getInput: ZIO[Any, Nothing, TaskInput] = ZIO.succeed(input)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RenderableTask
  ) extends zio.aws.sagemaker.model.RenderableTask.ReadOnly {
    override val input: TaskInput =
      zio.aws.sagemaker.model.primitives.TaskInput(impl.input())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RenderableTask
  ): zio.aws.sagemaker.model.RenderableTask.ReadOnly = new Wrapper(impl)
}
