package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait RecommendationJobStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus
}
object RecommendationJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus
  ): zio.aws.sagemaker.model.RecommendationJobStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.RecommendationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.sagemaker.model.RecommendationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.PENDING
  }
  case object IN_PROGRESS
      extends zio.aws.sagemaker.model.RecommendationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.IN_PROGRESS
  }
  case object COMPLETED
      extends zio.aws.sagemaker.model.RecommendationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.COMPLETED
  }
  case object FAILED extends zio.aws.sagemaker.model.RecommendationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.FAILED
  }
  case object STOPPING extends zio.aws.sagemaker.model.RecommendationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.STOPPING
  }
  case object STOPPED extends zio.aws.sagemaker.model.RecommendationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus.STOPPED
  }
}
