package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  JobDurationInSeconds,
  ModelPackageArn
}
import scala.jdk.CollectionConverters._
final case class RecommendationJobInputConfig(
    modelPackageVersionArn: ModelPackageArn,
    jobDurationInSeconds: Option[JobDurationInSeconds] = None,
    trafficPattern: Option[zio.aws.sagemaker.model.TrafficPattern] = None,
    resourceLimit: Option[
      zio.aws.sagemaker.model.RecommendationJobResourceLimit
    ] = None,
    endpointConfigurations: Option[
      Iterable[zio.aws.sagemaker.model.EndpointInputConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RecommendationJobInputConfig = {
    import RecommendationJobInputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobInputConfig
      .builder()
      .modelPackageVersionArn(
        ModelPackageArn.unwrap(modelPackageVersionArn): java.lang.String
      )
      .optionallyWith(
        jobDurationInSeconds.map(value =>
          JobDurationInSeconds.unwrap(value): Integer
        )
      )(_.jobDurationInSeconds)
      .optionallyWith(trafficPattern.map(value => value.buildAwsValue()))(
        _.trafficPattern
      )
      .optionallyWith(resourceLimit.map(value => value.buildAwsValue()))(
        _.resourceLimit
      )
      .optionallyWith(
        endpointConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RecommendationJobInputConfig.ReadOnly =
    zio.aws.sagemaker.model.RecommendationJobInputConfig.wrap(buildAwsValue())
}
object RecommendationJobInputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobInputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RecommendationJobInputConfig =
      zio.aws.sagemaker.model.RecommendationJobInputConfig(
        modelPackageVersionArn,
        jobDurationInSeconds.map(value => value),
        trafficPattern.map(value => value.asEditable),
        resourceLimit.map(value => value.asEditable),
        endpointConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def modelPackageVersionArn: ModelPackageArn
    def jobDurationInSeconds: Option[JobDurationInSeconds]
    def trafficPattern: Option[zio.aws.sagemaker.model.TrafficPattern.ReadOnly]
    def resourceLimit: Option[
      zio.aws.sagemaker.model.RecommendationJobResourceLimit.ReadOnly
    ]
    def endpointConfigurations: Option[
      List[zio.aws.sagemaker.model.EndpointInputConfiguration.ReadOnly]
    ]
    def getModelPackageVersionArn: ZIO[Any, Nothing, ModelPackageArn] =
      ZIO.succeed(modelPackageVersionArn)
    def getJobDurationInSeconds: ZIO[Any, AwsError, JobDurationInSeconds] =
      AwsError.unwrapOptionField("jobDurationInSeconds", jobDurationInSeconds)
    def getTrafficPattern
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrafficPattern.ReadOnly] =
      AwsError.unwrapOptionField("trafficPattern", trafficPattern)
    def getResourceLimit: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RecommendationJobResourceLimit.ReadOnly
    ] = AwsError.unwrapOptionField("resourceLimit", resourceLimit)
    def getEndpointConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.EndpointInputConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "endpointConfigurations",
      endpointConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobInputConfig
  ) extends zio.aws.sagemaker.model.RecommendationJobInputConfig.ReadOnly {
    override val modelPackageVersionArn: ModelPackageArn =
      zio.aws.sagemaker.model.primitives
        .ModelPackageArn(impl.modelPackageVersionArn())
    override val jobDurationInSeconds: Option[JobDurationInSeconds] = scala
      .Option(impl.jobDurationInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives.JobDurationInSeconds(value)
      )
    override val trafficPattern
        : Option[zio.aws.sagemaker.model.TrafficPattern.ReadOnly] = scala
      .Option(impl.trafficPattern())
      .map(value => zio.aws.sagemaker.model.TrafficPattern.wrap(value))
    override val resourceLimit: Option[
      zio.aws.sagemaker.model.RecommendationJobResourceLimit.ReadOnly
    ] = scala
      .Option(impl.resourceLimit())
      .map(value =>
        zio.aws.sagemaker.model.RecommendationJobResourceLimit.wrap(value)
      )
    override val endpointConfigurations: Option[
      List[zio.aws.sagemaker.model.EndpointInputConfiguration.ReadOnly]
    ] = scala
      .Option(impl.endpointConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.EndpointInputConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobInputConfig
  ): zio.aws.sagemaker.model.RecommendationJobInputConfig.ReadOnly =
    new Wrapper(impl)
}
