package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PublicWorkforceTaskPrice(
    amountInUsd: Option[zio.aws.sagemaker.model.USD] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PublicWorkforceTaskPrice = {
    import PublicWorkforceTaskPrice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PublicWorkforceTaskPrice
      .builder()
      .optionallyWith(amountInUsd.map(value => value.buildAwsValue()))(
        _.amountInUsd
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.PublicWorkforceTaskPrice.ReadOnly =
    zio.aws.sagemaker.model.PublicWorkforceTaskPrice.wrap(buildAwsValue())
}
object PublicWorkforceTaskPrice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PublicWorkforceTaskPrice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PublicWorkforceTaskPrice =
      zio.aws.sagemaker.model
        .PublicWorkforceTaskPrice(amountInUsd.map(value => value.asEditable))
    def amountInUsd: Option[zio.aws.sagemaker.model.USD.ReadOnly]
    def getAmountInUsd
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.USD.ReadOnly] =
      AwsError.unwrapOptionField("amountInUsd", amountInUsd)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PublicWorkforceTaskPrice
  ) extends zio.aws.sagemaker.model.PublicWorkforceTaskPrice.ReadOnly {
    override val amountInUsd: Option[zio.aws.sagemaker.model.USD.ReadOnly] =
      scala
        .Option(impl.amountInUsd())
        .map(value => zio.aws.sagemaker.model.USD.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PublicWorkforceTaskPrice
  ): zio.aws.sagemaker.model.PublicWorkforceTaskPrice.ReadOnly = new Wrapper(
    impl
  )
}
