package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  VariantWeight,
  InitialTaskCount,
  ModelName,
  VariantName
}
import scala.jdk.CollectionConverters._
final case class ProductionVariant(
    variantName: VariantName,
    modelName: ModelName,
    initialInstanceCount: Option[InitialTaskCount] = None,
    instanceType: Option[
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = None,
    initialVariantWeight: Option[VariantWeight] = None,
    acceleratorType: Option[
      zio.aws.sagemaker.model.ProductionVariantAcceleratorType
    ] = None,
    coreDumpConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig
    ] = None,
    serverlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProductionVariant = {
    import ProductionVariant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProductionVariant
      .builder()
      .variantName(VariantName.unwrap(variantName): java.lang.String)
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .optionallyWith(
        initialInstanceCount.map(value =>
          InitialTaskCount.unwrap(value): Integer
        )
      )(_.initialInstanceCount)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        initialVariantWeight.map(value =>
          VariantWeight.unwrap(value): java.lang.Float
        )
      )(_.initialVariantWeight)
      .optionallyWith(acceleratorType.map(value => value.unwrap))(
        _.acceleratorType
      )
      .optionallyWith(coreDumpConfig.map(value => value.buildAwsValue()))(
        _.coreDumpConfig
      )
      .optionallyWith(serverlessConfig.map(value => value.buildAwsValue()))(
        _.serverlessConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProductionVariant.ReadOnly =
    zio.aws.sagemaker.model.ProductionVariant.wrap(buildAwsValue())
}
object ProductionVariant {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProductionVariant
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProductionVariant =
      zio.aws.sagemaker.model.ProductionVariant(
        variantName,
        modelName,
        initialInstanceCount.map(value => value),
        instanceType.map(value => value),
        initialVariantWeight.map(value => value),
        acceleratorType.map(value => value),
        coreDumpConfig.map(value => value.asEditable),
        serverlessConfig.map(value => value.asEditable)
      )
    def variantName: VariantName
    def modelName: ModelName
    def initialInstanceCount: Option[InitialTaskCount]
    def instanceType
        : Option[zio.aws.sagemaker.model.ProductionVariantInstanceType]
    def initialVariantWeight: Option[VariantWeight]
    def acceleratorType
        : Option[zio.aws.sagemaker.model.ProductionVariantAcceleratorType]
    def coreDumpConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig.ReadOnly
    ]
    def serverlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ]
    def getVariantName: ZIO[Any, Nothing, VariantName] =
      ZIO.succeed(variantName)
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getInitialInstanceCount: ZIO[Any, AwsError, InitialTaskCount] =
      AwsError.unwrapOptionField("initialInstanceCount", initialInstanceCount)
    def getInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = AwsError.unwrapOptionField("instanceType", instanceType)
    def getInitialVariantWeight: ZIO[Any, AwsError, VariantWeight] =
      AwsError.unwrapOptionField("initialVariantWeight", initialVariantWeight)
    def getAcceleratorType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantAcceleratorType
    ] = AwsError.unwrapOptionField("acceleratorType", acceleratorType)
    def getCoreDumpConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig.ReadOnly
    ] = AwsError.unwrapOptionField("coreDumpConfig", coreDumpConfig)
    def getServerlessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = AwsError.unwrapOptionField("serverlessConfig", serverlessConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariant
  ) extends zio.aws.sagemaker.model.ProductionVariant.ReadOnly {
    override val variantName: VariantName =
      zio.aws.sagemaker.model.primitives.VariantName(impl.variantName())
    override val modelName: ModelName =
      zio.aws.sagemaker.model.primitives.ModelName(impl.modelName())
    override val initialInstanceCount: Option[InitialTaskCount] = scala
      .Option(impl.initialInstanceCount())
      .map(value => zio.aws.sagemaker.model.primitives.InitialTaskCount(value))
    override val instanceType
        : Option[zio.aws.sagemaker.model.ProductionVariantInstanceType] = scala
      .Option(impl.instanceType())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantInstanceType.wrap(value)
      )
    override val initialVariantWeight: Option[VariantWeight] = scala
      .Option(impl.initialVariantWeight())
      .map(value => zio.aws.sagemaker.model.primitives.VariantWeight(value))
    override val acceleratorType
        : Option[zio.aws.sagemaker.model.ProductionVariantAcceleratorType] =
      scala
        .Option(impl.acceleratorType())
        .map(value =>
          zio.aws.sagemaker.model.ProductionVariantAcceleratorType.wrap(value)
        )
    override val coreDumpConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig.ReadOnly
    ] = scala
      .Option(impl.coreDumpConfig())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig.wrap(value)
      )
    override val serverlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = scala
      .Option(impl.serverlessConfig())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantServerlessConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariant
  ): zio.aws.sagemaker.model.ProductionVariant.ReadOnly = new Wrapper(impl)
}
