package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  TaskCount,
  VariantWeight,
  VariantName
}
import scala.jdk.CollectionConverters._
final case class PendingProductionVariantSummary(
    variantName: VariantName,
    deployedImages: Option[Iterable[zio.aws.sagemaker.model.DeployedImage]] =
      None,
    currentWeight: Option[VariantWeight] = None,
    desiredWeight: Option[VariantWeight] = None,
    currentInstanceCount: Option[TaskCount] = None,
    desiredInstanceCount: Option[TaskCount] = None,
    instanceType: Option[
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = None,
    acceleratorType: Option[
      zio.aws.sagemaker.model.ProductionVariantAcceleratorType
    ] = None,
    variantStatus: Option[
      Iterable[zio.aws.sagemaker.model.ProductionVariantStatus]
    ] = None,
    currentServerlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig
    ] = None,
    desiredServerlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary = {
    import PendingProductionVariantSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary
      .builder()
      .variantName(VariantName.unwrap(variantName): java.lang.String)
      .optionallyWith(
        deployedImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deployedImages)
      .optionallyWith(
        currentWeight.map(value => VariantWeight.unwrap(value): java.lang.Float)
      )(_.currentWeight)
      .optionallyWith(
        desiredWeight.map(value => VariantWeight.unwrap(value): java.lang.Float)
      )(_.desiredWeight)
      .optionallyWith(
        currentInstanceCount.map(value => TaskCount.unwrap(value): Integer)
      )(_.currentInstanceCount)
      .optionallyWith(
        desiredInstanceCount.map(value => TaskCount.unwrap(value): Integer)
      )(_.desiredInstanceCount)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(acceleratorType.map(value => value.unwrap))(
        _.acceleratorType
      )
      .optionallyWith(
        variantStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.variantStatus)
      .optionallyWith(
        currentServerlessConfig.map(value => value.buildAwsValue())
      )(_.currentServerlessConfig)
      .optionallyWith(
        desiredServerlessConfig.map(value => value.buildAwsValue())
      )(_.desiredServerlessConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.PendingProductionVariantSummary.ReadOnly =
    zio.aws.sagemaker.model.PendingProductionVariantSummary
      .wrap(buildAwsValue())
}
object PendingProductionVariantSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PendingProductionVariantSummary =
      zio.aws.sagemaker.model.PendingProductionVariantSummary(
        variantName,
        deployedImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        currentWeight.map(value => value),
        desiredWeight.map(value => value),
        currentInstanceCount.map(value => value),
        desiredInstanceCount.map(value => value),
        instanceType.map(value => value),
        acceleratorType.map(value => value),
        variantStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        currentServerlessConfig.map(value => value.asEditable),
        desiredServerlessConfig.map(value => value.asEditable)
      )
    def variantName: VariantName
    def deployedImages
        : Option[List[zio.aws.sagemaker.model.DeployedImage.ReadOnly]]
    def currentWeight: Option[VariantWeight]
    def desiredWeight: Option[VariantWeight]
    def currentInstanceCount: Option[TaskCount]
    def desiredInstanceCount: Option[TaskCount]
    def instanceType
        : Option[zio.aws.sagemaker.model.ProductionVariantInstanceType]
    def acceleratorType
        : Option[zio.aws.sagemaker.model.ProductionVariantAcceleratorType]
    def variantStatus
        : Option[List[zio.aws.sagemaker.model.ProductionVariantStatus.ReadOnly]]
    def currentServerlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ]
    def desiredServerlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ]
    def getVariantName: ZIO[Any, Nothing, VariantName] =
      ZIO.succeed(variantName)
    def getDeployedImages: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.DeployedImage.ReadOnly
    ]] = AwsError.unwrapOptionField("deployedImages", deployedImages)
    def getCurrentWeight: ZIO[Any, AwsError, VariantWeight] =
      AwsError.unwrapOptionField("currentWeight", currentWeight)
    def getDesiredWeight: ZIO[Any, AwsError, VariantWeight] =
      AwsError.unwrapOptionField("desiredWeight", desiredWeight)
    def getCurrentInstanceCount: ZIO[Any, AwsError, TaskCount] =
      AwsError.unwrapOptionField("currentInstanceCount", currentInstanceCount)
    def getDesiredInstanceCount: ZIO[Any, AwsError, TaskCount] =
      AwsError.unwrapOptionField("desiredInstanceCount", desiredInstanceCount)
    def getInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = AwsError.unwrapOptionField("instanceType", instanceType)
    def getAcceleratorType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantAcceleratorType
    ] = AwsError.unwrapOptionField("acceleratorType", acceleratorType)
    def getVariantStatus: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProductionVariantStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("variantStatus", variantStatus)
    def getCurrentServerlessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "currentServerlessConfig",
      currentServerlessConfig
    )
    def getDesiredServerlessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "desiredServerlessConfig",
      desiredServerlessConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary
  ) extends zio.aws.sagemaker.model.PendingProductionVariantSummary.ReadOnly {
    override val variantName: VariantName =
      zio.aws.sagemaker.model.primitives.VariantName(impl.variantName())
    override val deployedImages
        : Option[List[zio.aws.sagemaker.model.DeployedImage.ReadOnly]] = scala
      .Option(impl.deployedImages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.DeployedImage.wrap(item)
        }.toList
      )
    override val currentWeight: Option[VariantWeight] = scala
      .Option(impl.currentWeight())
      .map(value => zio.aws.sagemaker.model.primitives.VariantWeight(value))
    override val desiredWeight: Option[VariantWeight] = scala
      .Option(impl.desiredWeight())
      .map(value => zio.aws.sagemaker.model.primitives.VariantWeight(value))
    override val currentInstanceCount: Option[TaskCount] = scala
      .Option(impl.currentInstanceCount())
      .map(value => zio.aws.sagemaker.model.primitives.TaskCount(value))
    override val desiredInstanceCount: Option[TaskCount] = scala
      .Option(impl.desiredInstanceCount())
      .map(value => zio.aws.sagemaker.model.primitives.TaskCount(value))
    override val instanceType
        : Option[zio.aws.sagemaker.model.ProductionVariantInstanceType] = scala
      .Option(impl.instanceType())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantInstanceType.wrap(value)
      )
    override val acceleratorType
        : Option[zio.aws.sagemaker.model.ProductionVariantAcceleratorType] =
      scala
        .Option(impl.acceleratorType())
        .map(value =>
          zio.aws.sagemaker.model.ProductionVariantAcceleratorType.wrap(value)
        )
    override val variantStatus: Option[
      List[zio.aws.sagemaker.model.ProductionVariantStatus.ReadOnly]
    ] = scala
      .Option(impl.variantStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProductionVariantStatus.wrap(item)
        }.toList
      )
    override val currentServerlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = scala
      .Option(impl.currentServerlessConfig())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantServerlessConfig.wrap(value)
      )
    override val desiredServerlessConfig: Option[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = scala
      .Option(impl.desiredServerlessConfig())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantServerlessConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary
  ): zio.aws.sagemaker.model.PendingProductionVariantSummary.ReadOnly =
    new Wrapper(impl)
}
