package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  LastModifiedTime,
  CreationTime,
  NotebookInstanceLifecycleConfigArn,
  NotebookInstanceLifecycleConfigName
}
import scala.jdk.CollectionConverters._
final case class NotebookInstanceLifecycleConfigSummary(
    notebookInstanceLifecycleConfigName: NotebookInstanceLifecycleConfigName,
    notebookInstanceLifecycleConfigArn: NotebookInstanceLifecycleConfigArn,
    creationTime: Option[CreationTime] = None,
    lastModifiedTime: Option[LastModifiedTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSummary = {
    import NotebookInstanceLifecycleConfigSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSummary
      .builder()
      .notebookInstanceLifecycleConfigName(
        NotebookInstanceLifecycleConfigName.unwrap(
          notebookInstanceLifecycleConfigName
        ): java.lang.String
      )
      .notebookInstanceLifecycleConfigArn(
        NotebookInstanceLifecycleConfigArn.unwrap(
          notebookInstanceLifecycleConfigArn
        ): java.lang.String
      )
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary.ReadOnly =
    zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary
      .wrap(buildAwsValue())
}
object NotebookInstanceLifecycleConfigSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary =
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary(
        notebookInstanceLifecycleConfigName,
        notebookInstanceLifecycleConfigArn,
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def notebookInstanceLifecycleConfigName: NotebookInstanceLifecycleConfigName
    def notebookInstanceLifecycleConfigArn: NotebookInstanceLifecycleConfigArn
    def creationTime: Option[CreationTime]
    def lastModifiedTime: Option[LastModifiedTime]
    def getNotebookInstanceLifecycleConfigName
        : ZIO[Any, Nothing, NotebookInstanceLifecycleConfigName] =
      ZIO.succeed(notebookInstanceLifecycleConfigName)
    def getNotebookInstanceLifecycleConfigArn
        : ZIO[Any, Nothing, NotebookInstanceLifecycleConfigArn] =
      ZIO.succeed(notebookInstanceLifecycleConfigArn)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSummary
  ) extends zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary.ReadOnly {
    override val notebookInstanceLifecycleConfigName
        : NotebookInstanceLifecycleConfigName =
      zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigName(
        impl.notebookInstanceLifecycleConfigName()
      )
    override val notebookInstanceLifecycleConfigArn
        : NotebookInstanceLifecycleConfigArn =
      zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigArn(
        impl.notebookInstanceLifecycleConfigArn()
      )
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTime: Option[LastModifiedTime] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.LastModifiedTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSummary
  ): zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary.ReadOnly =
    new Wrapper(impl)
}
