package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  KmsKeyId,
  ProcessingVolumeSizeInGB,
  ProcessingInstanceCount
}
import scala.jdk.CollectionConverters._
final case class MonitoringClusterConfig(
    instanceCount: ProcessingInstanceCount,
    instanceType: zio.aws.sagemaker.model.ProcessingInstanceType,
    volumeSizeInGB: ProcessingVolumeSizeInGB,
    volumeKmsKeyId: Option[KmsKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringClusterConfig = {
    import MonitoringClusterConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringClusterConfig
      .builder()
      .instanceCount(ProcessingInstanceCount.unwrap(instanceCount): Integer)
      .instanceType(instanceType.unwrap)
      .volumeSizeInGB(ProcessingVolumeSizeInGB.unwrap(volumeSizeInGB): Integer)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringClusterConfig.ReadOnly =
    zio.aws.sagemaker.model.MonitoringClusterConfig.wrap(buildAwsValue())
}
object MonitoringClusterConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringClusterConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringClusterConfig =
      zio.aws.sagemaker.model.MonitoringClusterConfig(
        instanceCount,
        instanceType,
        volumeSizeInGB,
        volumeKmsKeyId.map(value => value)
      )
    def instanceCount: ProcessingInstanceCount
    def instanceType: zio.aws.sagemaker.model.ProcessingInstanceType
    def volumeSizeInGB: ProcessingVolumeSizeInGB
    def volumeKmsKeyId: Option[KmsKeyId]
    def getInstanceCount: ZIO[Any, Nothing, ProcessingInstanceCount] =
      ZIO.succeed(instanceCount)
    def getInstanceType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ProcessingInstanceType] =
      ZIO.succeed(instanceType)
    def getVolumeSizeInGB: ZIO[Any, Nothing, ProcessingVolumeSizeInGB] =
      ZIO.succeed(volumeSizeInGB)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringClusterConfig
  ) extends zio.aws.sagemaker.model.MonitoringClusterConfig.ReadOnly {
    override val instanceCount: ProcessingInstanceCount =
      zio.aws.sagemaker.model.primitives
        .ProcessingInstanceCount(impl.instanceCount())
    override val instanceType: zio.aws.sagemaker.model.ProcessingInstanceType =
      zio.aws.sagemaker.model.ProcessingInstanceType.wrap(impl.instanceType())
    override val volumeSizeInGB: ProcessingVolumeSizeInGB =
      zio.aws.sagemaker.model.primitives
        .ProcessingVolumeSizeInGB(impl.volumeSizeInGB())
    override val volumeKmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.volumeKmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringClusterConfig
  ): zio.aws.sagemaker.model.MonitoringClusterConfig.ReadOnly = new Wrapper(
    impl
  )
}
