package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class ModelPackageStatusItem(
    name: EntityName,
    status: zio.aws.sagemaker.model.DetailedModelPackageStatus,
    failureReason: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusItem = {
    import ModelPackageStatusItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusItem
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelPackageStatusItem.ReadOnly =
    zio.aws.sagemaker.model.ModelPackageStatusItem.wrap(buildAwsValue())
}
object ModelPackageStatusItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelPackageStatusItem =
      zio.aws.sagemaker.model
        .ModelPackageStatusItem(name, status, failureReason.map(value => value))
    def name: EntityName
    def status: zio.aws.sagemaker.model.DetailedModelPackageStatus
    def failureReason: Option[String]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.DetailedModelPackageStatus
    ] = ZIO.succeed(status)
    def getFailureReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusItem
  ) extends zio.aws.sagemaker.model.ModelPackageStatusItem.ReadOnly {
    override val name: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.name())
    override val status: zio.aws.sagemaker.model.DetailedModelPackageStatus =
      zio.aws.sagemaker.model.DetailedModelPackageStatus.wrap(impl.status())
    override val failureReason: Option[String] =
      scala.Option(impl.failureReason()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusItem
  ): zio.aws.sagemaker.model.ModelPackageStatusItem.ReadOnly = new Wrapper(impl)
}
