package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModelMetrics(
    modelQuality: Option[zio.aws.sagemaker.model.ModelQuality] = None,
    modelDataQuality: Option[zio.aws.sagemaker.model.ModelDataQuality] = None,
    bias: Option[zio.aws.sagemaker.model.Bias] = None,
    explainability: Option[zio.aws.sagemaker.model.Explainability] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelMetrics = {
    import ModelMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelMetrics
      .builder()
      .optionallyWith(modelQuality.map(value => value.buildAwsValue()))(
        _.modelQuality
      )
      .optionallyWith(modelDataQuality.map(value => value.buildAwsValue()))(
        _.modelDataQuality
      )
      .optionallyWith(bias.map(value => value.buildAwsValue()))(_.bias)
      .optionallyWith(explainability.map(value => value.buildAwsValue()))(
        _.explainability
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelMetrics.ReadOnly =
    zio.aws.sagemaker.model.ModelMetrics.wrap(buildAwsValue())
}
object ModelMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelMetrics =
      zio.aws.sagemaker.model.ModelMetrics(
        modelQuality.map(value => value.asEditable),
        modelDataQuality.map(value => value.asEditable),
        bias.map(value => value.asEditable),
        explainability.map(value => value.asEditable)
      )
    def modelQuality: Option[zio.aws.sagemaker.model.ModelQuality.ReadOnly]
    def modelDataQuality
        : Option[zio.aws.sagemaker.model.ModelDataQuality.ReadOnly]
    def bias: Option[zio.aws.sagemaker.model.Bias.ReadOnly]
    def explainability: Option[zio.aws.sagemaker.model.Explainability.ReadOnly]
    def getModelQuality
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelQuality.ReadOnly] =
      AwsError.unwrapOptionField("modelQuality", modelQuality)
    def getModelDataQuality: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelDataQuality.ReadOnly
    ] = AwsError.unwrapOptionField("modelDataQuality", modelDataQuality)
    def getBias: ZIO[Any, AwsError, zio.aws.sagemaker.model.Bias.ReadOnly] =
      AwsError.unwrapOptionField("bias", bias)
    def getExplainability
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.Explainability.ReadOnly] =
      AwsError.unwrapOptionField("explainability", explainability)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelMetrics
  ) extends zio.aws.sagemaker.model.ModelMetrics.ReadOnly {
    override val modelQuality
        : Option[zio.aws.sagemaker.model.ModelQuality.ReadOnly] = scala
      .Option(impl.modelQuality())
      .map(value => zio.aws.sagemaker.model.ModelQuality.wrap(value))
    override val modelDataQuality
        : Option[zio.aws.sagemaker.model.ModelDataQuality.ReadOnly] = scala
      .Option(impl.modelDataQuality())
      .map(value => zio.aws.sagemaker.model.ModelDataQuality.wrap(value))
    override val bias: Option[zio.aws.sagemaker.model.Bias.ReadOnly] = scala
      .Option(impl.bias())
      .map(value => zio.aws.sagemaker.model.Bias.wrap(value))
    override val explainability
        : Option[zio.aws.sagemaker.model.Explainability.ReadOnly] = scala
      .Option(impl.explainability())
      .map(value => zio.aws.sagemaker.model.Explainability.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelMetrics
  ): zio.aws.sagemaker.model.ModelMetrics.ReadOnly = new Wrapper(impl)
}
