package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListModelBiasJobDefinitionsResponse(
    jobDefinitionSummaries: Iterable[
      zio.aws.sagemaker.model.MonitoringJobDefinitionSummary
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse = {
    import ListModelBiasJobDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse
      .builder()
      .jobDefinitionSummaries(jobDefinitionSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListModelBiasJobDefinitionsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListModelBiasJobDefinitionsResponse
      .wrap(buildAwsValue())
}
object ListModelBiasJobDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListModelBiasJobDefinitionsResponse =
      zio.aws.sagemaker.model.ListModelBiasJobDefinitionsResponse(
        jobDefinitionSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def jobDefinitionSummaries
        : List[zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getJobDefinitionSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
    ]] = ZIO.succeed(jobDefinitionSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse
  ) extends zio.aws.sagemaker.model.ListModelBiasJobDefinitionsResponse.ReadOnly {
    override val jobDefinitionSummaries: List[
      zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
    ] = impl
      .jobDefinitionSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse
  ): zio.aws.sagemaker.model.ListModelBiasJobDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
