package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  ExperimentEntityName,
  LineageGroupArn
}
import scala.jdk.CollectionConverters._
final case class LineageGroupSummary(
    lineageGroupArn: Option[LineageGroupArn] = None,
    lineageGroupName: Option[ExperimentEntityName] = None,
    displayName: Option[ExperimentEntityName] = None,
    creationTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LineageGroupSummary = {
    import LineageGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LineageGroupSummary
      .builder()
      .optionallyWith(
        lineageGroupArn.map(value =>
          LineageGroupArn.unwrap(value): java.lang.String
        )
      )(_.lineageGroupArn)
      .optionallyWith(
        lineageGroupName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.lineageGroupName)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly =
    zio.aws.sagemaker.model.LineageGroupSummary.wrap(buildAwsValue())
}
object LineageGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LineageGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LineageGroupSummary =
      zio.aws.sagemaker.model.LineageGroupSummary(
        lineageGroupArn.map(value => value),
        lineageGroupName.map(value => value),
        displayName.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def lineageGroupArn: Option[LineageGroupArn]
    def lineageGroupName: Option[ExperimentEntityName]
    def displayName: Option[ExperimentEntityName]
    def creationTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def getLineageGroupArn: ZIO[Any, AwsError, LineageGroupArn] =
      AwsError.unwrapOptionField("lineageGroupArn", lineageGroupArn)
    def getLineageGroupName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("lineageGroupName", lineageGroupName)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LineageGroupSummary
  ) extends zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly {
    override val lineageGroupArn: Option[LineageGroupArn] = scala
      .Option(impl.lineageGroupArn())
      .map(value => zio.aws.sagemaker.model.primitives.LineageGroupArn(value))
    override val lineageGroupName: Option[ExperimentEntityName] = scala
      .Option(impl.lineageGroupName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val displayName: Option[ExperimentEntityName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LineageGroupSummary
  ): zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly = new Wrapper(impl)
}
