package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait DirectInternetAccess {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.DirectInternetAccess
}
object DirectInternetAccess {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.DirectInternetAccess
  ): zio.aws.sagemaker.model.DirectInternetAccess = value match {
    case software.amazon.awssdk.services.sagemaker.model.DirectInternetAccess.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.DirectInternetAccess.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.sagemaker.model.DirectInternetAccess.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.DirectInternetAccess {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DirectInternetAccess =
      software.amazon.awssdk.services.sagemaker.model.DirectInternetAccess.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.sagemaker.model.DirectInternetAccess {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DirectInternetAccess =
      software.amazon.awssdk.services.sagemaker.model.DirectInternetAccess.ENABLED
  }
  case object Disabled extends zio.aws.sagemaker.model.DirectInternetAccess {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DirectInternetAccess =
      software.amazon.awssdk.services.sagemaker.model.DirectInternetAccess.DISABLED
  }
}
