package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  EndpointName,
  MonitoringScheduleName,
  Timestamp,
  FailureReason,
  MonitoringScheduleArn
}
import scala.jdk.CollectionConverters._
final case class DescribeMonitoringScheduleResponse(
    monitoringScheduleArn: MonitoringScheduleArn,
    monitoringScheduleName: MonitoringScheduleName,
    monitoringScheduleStatus: zio.aws.sagemaker.model.ScheduleStatus,
    monitoringType: Option[zio.aws.sagemaker.model.MonitoringType] = None,
    failureReason: Option[FailureReason] = None,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp,
    monitoringScheduleConfig: zio.aws.sagemaker.model.MonitoringScheduleConfig,
    endpointName: Option[EndpointName] = None,
    lastMonitoringExecutionSummary: Option[
      zio.aws.sagemaker.model.MonitoringExecutionSummary
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleResponse = {
    import DescribeMonitoringScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleResponse
      .builder()
      .monitoringScheduleArn(
        MonitoringScheduleArn.unwrap(monitoringScheduleArn): java.lang.String
      )
      .monitoringScheduleName(
        MonitoringScheduleName.unwrap(monitoringScheduleName): java.lang.String
      )
      .monitoringScheduleStatus(monitoringScheduleStatus.unwrap)
      .optionallyWith(monitoringType.map(value => value.unwrap))(
        _.monitoringType
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .monitoringScheduleConfig(monitoringScheduleConfig.buildAwsValue())
      .optionallyWith(
        endpointName.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.endpointName)
      .optionallyWith(
        lastMonitoringExecutionSummary.map(value => value.buildAwsValue())
      )(_.lastMonitoringExecutionSummary)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeMonitoringScheduleResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeMonitoringScheduleResponse
      .wrap(buildAwsValue())
}
object DescribeMonitoringScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeMonitoringScheduleResponse =
      zio.aws.sagemaker.model.DescribeMonitoringScheduleResponse(
        monitoringScheduleArn,
        monitoringScheduleName,
        monitoringScheduleStatus,
        monitoringType.map(value => value),
        failureReason.map(value => value),
        creationTime,
        lastModifiedTime,
        monitoringScheduleConfig.asEditable,
        endpointName.map(value => value),
        lastMonitoringExecutionSummary.map(value => value.asEditable)
      )
    def monitoringScheduleArn: MonitoringScheduleArn
    def monitoringScheduleName: MonitoringScheduleName
    def monitoringScheduleStatus: zio.aws.sagemaker.model.ScheduleStatus
    def monitoringType: Option[zio.aws.sagemaker.model.MonitoringType]
    def failureReason: Option[FailureReason]
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def monitoringScheduleConfig
        : zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly
    def endpointName: Option[EndpointName]
    def lastMonitoringExecutionSummary
        : Option[zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly]
    def getMonitoringScheduleArn: ZIO[Any, Nothing, MonitoringScheduleArn] =
      ZIO.succeed(monitoringScheduleArn)
    def getMonitoringScheduleName: ZIO[Any, Nothing, MonitoringScheduleName] =
      ZIO.succeed(monitoringScheduleName)
    def getMonitoringScheduleStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ScheduleStatus] =
      ZIO.succeed(monitoringScheduleStatus)
    def getMonitoringType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MonitoringType] =
      AwsError.unwrapOptionField("monitoringType", monitoringType)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getMonitoringScheduleConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly
    ] = ZIO.succeed(monitoringScheduleConfig)
    def getEndpointName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getLastMonitoringExecutionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lastMonitoringExecutionSummary",
      lastMonitoringExecutionSummary
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleResponse
  ) extends zio.aws.sagemaker.model.DescribeMonitoringScheduleResponse.ReadOnly {
    override val monitoringScheduleArn: MonitoringScheduleArn =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleArn(impl.monitoringScheduleArn())
    override val monitoringScheduleName: MonitoringScheduleName =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleName(impl.monitoringScheduleName())
    override val monitoringScheduleStatus
        : zio.aws.sagemaker.model.ScheduleStatus =
      zio.aws.sagemaker.model.ScheduleStatus
        .wrap(impl.monitoringScheduleStatus())
    override val monitoringType
        : Option[zio.aws.sagemaker.model.MonitoringType] = scala
      .Option(impl.monitoringType())
      .map(value => zio.aws.sagemaker.model.MonitoringType.wrap(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val monitoringScheduleConfig
        : zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly =
      zio.aws.sagemaker.model.MonitoringScheduleConfig
        .wrap(impl.monitoringScheduleConfig())
    override val endpointName: Option[EndpointName] = scala
      .Option(impl.endpointName())
      .map(value => zio.aws.sagemaker.model.primitives.EndpointName(value))
    override val lastMonitoringExecutionSummary
        : Option[zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly] =
      scala
        .Option(impl.lastMonitoringExecutionSummary())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringExecutionSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleResponse
  ): zio.aws.sagemaker.model.DescribeMonitoringScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
