package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  EdgeVersion,
  EdgePackagingJobArn,
  S3Uri,
  Timestamp,
  KmsKeyId,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class DescribeEdgePackagingJobResponse(
    edgePackagingJobArn: EdgePackagingJobArn,
    edgePackagingJobName: EntityName,
    compilationJobName: Option[EntityName] = None,
    modelName: Option[EntityName] = None,
    modelVersion: Option[EdgeVersion] = None,
    roleArn: Option[RoleArn] = None,
    outputConfig: Option[zio.aws.sagemaker.model.EdgeOutputConfig] = None,
    resourceKey: Option[KmsKeyId] = None,
    edgePackagingJobStatus: zio.aws.sagemaker.model.EdgePackagingJobStatus,
    edgePackagingJobStatusMessage: Option[String] = None,
    creationTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    modelArtifact: Option[S3Uri] = None,
    modelSignature: Option[String] = None,
    presetDeploymentOutput: Option[
      zio.aws.sagemaker.model.EdgePresetDeploymentOutput
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse = {
    import DescribeEdgePackagingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse
      .builder()
      .edgePackagingJobArn(
        EdgePackagingJobArn.unwrap(edgePackagingJobArn): java.lang.String
      )
      .edgePackagingJobName(
        EntityName.unwrap(edgePackagingJobName): java.lang.String
      )
      .optionallyWith(
        compilationJobName.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.compilationJobName)
      .optionallyWith(
        modelName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelVersion.map(value => EdgeVersion.unwrap(value): java.lang.String)
      )(_.modelVersion)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(
        resourceKey.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.resourceKey)
      .edgePackagingJobStatus(edgePackagingJobStatus.unwrap)
      .optionallyWith(
        edgePackagingJobStatusMessage.map(value => value: java.lang.String)
      )(_.edgePackagingJobStatusMessage)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        modelArtifact.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.modelArtifact)
      .optionallyWith(modelSignature.map(value => value: java.lang.String))(
        _.modelSignature
      )
      .optionallyWith(
        presetDeploymentOutput.map(value => value.buildAwsValue())
      )(_.presetDeploymentOutput)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse
      .wrap(buildAwsValue())
}
object DescribeEdgePackagingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse =
      zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse(
        edgePackagingJobArn,
        edgePackagingJobName,
        compilationJobName.map(value => value),
        modelName.map(value => value),
        modelVersion.map(value => value),
        roleArn.map(value => value),
        outputConfig.map(value => value.asEditable),
        resourceKey.map(value => value),
        edgePackagingJobStatus,
        edgePackagingJobStatusMessage.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        modelArtifact.map(value => value),
        modelSignature.map(value => value),
        presetDeploymentOutput.map(value => value.asEditable)
      )
    def edgePackagingJobArn: EdgePackagingJobArn
    def edgePackagingJobName: EntityName
    def compilationJobName: Option[EntityName]
    def modelName: Option[EntityName]
    def modelVersion: Option[EdgeVersion]
    def roleArn: Option[RoleArn]
    def outputConfig: Option[zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly]
    def resourceKey: Option[KmsKeyId]
    def edgePackagingJobStatus: zio.aws.sagemaker.model.EdgePackagingJobStatus
    def edgePackagingJobStatusMessage: Option[String]
    def creationTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def modelArtifact: Option[S3Uri]
    def modelSignature: Option[String]
    def presetDeploymentOutput
        : Option[zio.aws.sagemaker.model.EdgePresetDeploymentOutput.ReadOnly]
    def getEdgePackagingJobArn: ZIO[Any, Nothing, EdgePackagingJobArn] =
      ZIO.succeed(edgePackagingJobArn)
    def getEdgePackagingJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgePackagingJobName)
    def getCompilationJobName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("compilationJobName", compilationJobName)
    def getModelName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelVersion: ZIO[Any, AwsError, EdgeVersion] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getResourceKey: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("resourceKey", resourceKey)
    def getEdgePackagingJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EdgePackagingJobStatus] =
      ZIO.succeed(edgePackagingJobStatus)
    def getEdgePackagingJobStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "edgePackagingJobStatusMessage",
        edgePackagingJobStatusMessage
      )
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getModelArtifact: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("modelArtifact", modelArtifact)
    def getModelSignature: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("modelSignature", modelSignature)
    def getPresetDeploymentOutput: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.EdgePresetDeploymentOutput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "presetDeploymentOutput",
      presetDeploymentOutput
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse
  ) extends zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse.ReadOnly {
    override val edgePackagingJobArn: EdgePackagingJobArn =
      zio.aws.sagemaker.model.primitives
        .EdgePackagingJobArn(impl.edgePackagingJobArn())
    override val edgePackagingJobName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.edgePackagingJobName())
    override val compilationJobName: Option[EntityName] = scala
      .Option(impl.compilationJobName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelName: Option[EntityName] = scala
      .Option(impl.modelName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelVersion: Option[EdgeVersion] = scala
      .Option(impl.modelVersion())
      .map(value => zio.aws.sagemaker.model.primitives.EdgeVersion(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val outputConfig
        : Option[zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly] = scala
      .Option(impl.outputConfig())
      .map(value => zio.aws.sagemaker.model.EdgeOutputConfig.wrap(value))
    override val resourceKey: Option[KmsKeyId] = scala
      .Option(impl.resourceKey())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val edgePackagingJobStatus
        : zio.aws.sagemaker.model.EdgePackagingJobStatus =
      zio.aws.sagemaker.model.EdgePackagingJobStatus
        .wrap(impl.edgePackagingJobStatus())
    override val edgePackagingJobStatusMessage: Option[String] = scala
      .Option(impl.edgePackagingJobStatusMessage())
      .map(value => value: String)
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modelArtifact: Option[S3Uri] = scala
      .Option(impl.modelArtifact())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val modelSignature: Option[String] =
      scala.Option(impl.modelSignature()).map(value => value: String)
    override val presetDeploymentOutput
        : Option[zio.aws.sagemaker.model.EdgePresetDeploymentOutput.ReadOnly] =
      scala
        .Option(impl.presetDeploymentOutput())
        .map(value =>
          zio.aws.sagemaker.model.EdgePresetDeploymentOutput.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse
  ): zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse.ReadOnly =
    new Wrapper(impl)
}
