package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.WorkteamArn
import scala.jdk.CollectionConverters._
final case class CreateWorkteamResponse(
    workteamArn: Option[WorkteamArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateWorkteamResponse = {
    import CreateWorkteamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateWorkteamResponse
      .builder()
      .optionallyWith(
        workteamArn.map(value => WorkteamArn.unwrap(value): java.lang.String)
      )(_.workteamArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateWorkteamResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateWorkteamResponse.wrap(buildAwsValue())
}
object CreateWorkteamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateWorkteamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateWorkteamResponse =
      zio.aws.sagemaker.model
        .CreateWorkteamResponse(workteamArn.map(value => value))
    def workteamArn: Option[WorkteamArn]
    def getWorkteamArn: ZIO[Any, AwsError, WorkteamArn] =
      AwsError.unwrapOptionField("workteamArn", workteamArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateWorkteamResponse
  ) extends zio.aws.sagemaker.model.CreateWorkteamResponse.ReadOnly {
    override val workteamArn: Option[WorkteamArn] = scala
      .Option(impl.workteamArn())
      .map(value => zio.aws.sagemaker.model.primitives.WorkteamArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateWorkteamResponse
  ): zio.aws.sagemaker.model.CreateWorkteamResponse.ReadOnly = new Wrapper(impl)
}
