package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ArtifactArn
import scala.jdk.CollectionConverters._
final case class CreateArtifactResponse(
    artifactArn: Option[ArtifactArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateArtifactResponse = {
    import CreateArtifactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateArtifactResponse
      .builder()
      .optionallyWith(
        artifactArn.map(value => ArtifactArn.unwrap(value): java.lang.String)
      )(_.artifactArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateArtifactResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateArtifactResponse.wrap(buildAwsValue())
}
object CreateArtifactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateArtifactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateArtifactResponse =
      zio.aws.sagemaker.model
        .CreateArtifactResponse(artifactArn.map(value => value))
    def artifactArn: Option[ArtifactArn]
    def getArtifactArn: ZIO[Any, AwsError, ArtifactArn] =
      AwsError.unwrapOptionField("artifactArn", artifactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateArtifactResponse
  ) extends zio.aws.sagemaker.model.CreateArtifactResponse.ReadOnly {
    override val artifactArn: Option[ArtifactArn] = scala
      .Option(impl.artifactArn())
      .map(value => zio.aws.sagemaker.model.primitives.ArtifactArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateArtifactResponse
  ): zio.aws.sagemaker.model.CreateArtifactResponse.ReadOnly = new Wrapper(impl)
}
