package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  WorkforceArn,
  WorkforceName
}
import scala.jdk.CollectionConverters._
final case class Workforce(
    workforceName: WorkforceName,
    workforceArn: WorkforceArn,
    lastUpdatedDate: Option[Timestamp] = None,
    sourceIpConfig: Option[zio.aws.sagemaker.model.SourceIpConfig] = None,
    subDomain: Option[String] = None,
    cognitoConfig: Option[zio.aws.sagemaker.model.CognitoConfig] = None,
    oidcConfig: Option[zio.aws.sagemaker.model.OidcConfigForResponse] = None,
    createDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Workforce = {
    import Workforce.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Workforce
      .builder()
      .workforceName(WorkforceName.unwrap(workforceName): java.lang.String)
      .workforceArn(WorkforceArn.unwrap(workforceArn): java.lang.String)
      .optionallyWith(
        lastUpdatedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDate)
      .optionallyWith(sourceIpConfig.map(value => value.buildAwsValue()))(
        _.sourceIpConfig
      )
      .optionallyWith(subDomain.map(value => value: java.lang.String))(
        _.subDomain
      )
      .optionallyWith(cognitoConfig.map(value => value.buildAwsValue()))(
        _.cognitoConfig
      )
      .optionallyWith(oidcConfig.map(value => value.buildAwsValue()))(
        _.oidcConfig
      )
      .optionallyWith(
        createDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createDate)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Workforce.ReadOnly =
    zio.aws.sagemaker.model.Workforce.wrap(buildAwsValue())
}
object Workforce {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.Workforce
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Workforce =
      zio.aws.sagemaker.model.Workforce(
        workforceName,
        workforceArn,
        lastUpdatedDate.map(value => value),
        sourceIpConfig.map(value => value.asEditable),
        subDomain.map(value => value),
        cognitoConfig.map(value => value.asEditable),
        oidcConfig.map(value => value.asEditable),
        createDate.map(value => value)
      )
    def workforceName: WorkforceName
    def workforceArn: WorkforceArn
    def lastUpdatedDate: Option[Timestamp]
    def sourceIpConfig: Option[zio.aws.sagemaker.model.SourceIpConfig.ReadOnly]
    def subDomain: Option[String]
    def cognitoConfig: Option[zio.aws.sagemaker.model.CognitoConfig.ReadOnly]
    def oidcConfig
        : Option[zio.aws.sagemaker.model.OidcConfigForResponse.ReadOnly]
    def createDate: Option[Timestamp]
    def getWorkforceName: ZIO[Any, Nothing, WorkforceName] =
      ZIO.succeed(workforceName)
    def getWorkforceArn: ZIO[Any, Nothing, WorkforceArn] =
      ZIO.succeed(workforceArn)
    def getLastUpdatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
    def getSourceIpConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SourceIpConfig.ReadOnly] =
      AwsError.unwrapOptionField("sourceIpConfig", sourceIpConfig)
    def getSubDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subDomain", subDomain)
    def getCognitoConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CognitoConfig.ReadOnly] =
      AwsError.unwrapOptionField("cognitoConfig", cognitoConfig)
    def getOidcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OidcConfigForResponse.ReadOnly
    ] = AwsError.unwrapOptionField("oidcConfig", oidcConfig)
    def getCreateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createDate", createDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Workforce
  ) extends zio.aws.sagemaker.model.Workforce.ReadOnly {
    override val workforceName: WorkforceName =
      zio.aws.sagemaker.model.primitives.WorkforceName(impl.workforceName())
    override val workforceArn: WorkforceArn =
      zio.aws.sagemaker.model.primitives.WorkforceArn(impl.workforceArn())
    override val lastUpdatedDate: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDate())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sourceIpConfig
        : Option[zio.aws.sagemaker.model.SourceIpConfig.ReadOnly] = scala
      .Option(impl.sourceIpConfig())
      .map(value => zio.aws.sagemaker.model.SourceIpConfig.wrap(value))
    override val subDomain: Option[String] =
      scala.Option(impl.subDomain()).map(value => value: String)
    override val cognitoConfig
        : Option[zio.aws.sagemaker.model.CognitoConfig.ReadOnly] = scala
      .Option(impl.cognitoConfig())
      .map(value => zio.aws.sagemaker.model.CognitoConfig.wrap(value))
    override val oidcConfig
        : Option[zio.aws.sagemaker.model.OidcConfigForResponse.ReadOnly] = scala
      .Option(impl.oidcConfig())
      .map(value => zio.aws.sagemaker.model.OidcConfigForResponse.wrap(value))
    override val createDate: Option[Timestamp] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Workforce
  ): zio.aws.sagemaker.model.Workforce.ReadOnly = new Wrapper(impl)
}
