package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{String200, WorkteamName}
import scala.jdk.CollectionConverters._
final case class UpdateWorkteamRequest(
    workteamName: WorkteamName,
    memberDefinitions: Option[
      Iterable[zio.aws.sagemaker.model.MemberDefinition]
    ] = None,
    description: Option[String200] = None,
    notificationConfiguration: Option[
      zio.aws.sagemaker.model.NotificationConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamRequest = {
    import UpdateWorkteamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamRequest
      .builder()
      .workteamName(WorkteamName.unwrap(workteamName): java.lang.String)
      .optionallyWith(
        memberDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.memberDefinitions)
      .optionallyWith(
        description.map(value => String200.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        notificationConfiguration.map(value => value.buildAwsValue())
      )(_.notificationConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateWorkteamRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateWorkteamRequest.wrap(buildAwsValue())
}
object UpdateWorkteamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateWorkteamRequest =
      zio.aws.sagemaker.model.UpdateWorkteamRequest(
        workteamName,
        memberDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value),
        notificationConfiguration.map(value => value.asEditable)
      )
    def workteamName: WorkteamName
    def memberDefinitions
        : Option[List[zio.aws.sagemaker.model.MemberDefinition.ReadOnly]]
    def description: Option[String200]
    def notificationConfiguration
        : Option[zio.aws.sagemaker.model.NotificationConfiguration.ReadOnly]
    def getWorkteamName: ZIO[Any, Nothing, WorkteamName] =
      ZIO.succeed(workteamName)
    def getMemberDefinitions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.MemberDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("memberDefinitions", memberDefinitions)
    def getDescription: ZIO[Any, AwsError, String200] =
      AwsError.unwrapOptionField("description", description)
    def getNotificationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.NotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "notificationConfiguration",
      notificationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamRequest
  ) extends zio.aws.sagemaker.model.UpdateWorkteamRequest.ReadOnly {
    override val workteamName: WorkteamName =
      zio.aws.sagemaker.model.primitives.WorkteamName(impl.workteamName())
    override val memberDefinitions
        : Option[List[zio.aws.sagemaker.model.MemberDefinition.ReadOnly]] =
      scala
        .Option(impl.memberDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.MemberDefinition.wrap(item)
          }.toList
        )
    override val description: Option[String200] = scala
      .Option(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.String200(value))
    override val notificationConfiguration
        : Option[zio.aws.sagemaker.model.NotificationConfiguration.ReadOnly] =
      scala
        .Option(impl.notificationConfiguration())
        .map(value =>
          zio.aws.sagemaker.model.NotificationConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamRequest
  ): zio.aws.sagemaker.model.UpdateWorkteamRequest.ReadOnly = new Wrapper(impl)
}
