package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ServiceCatalogEntityId
import scala.jdk.CollectionConverters._
final case class ServiceCatalogProvisioningDetails(
    productId: ServiceCatalogEntityId,
    provisioningArtifactId: Option[ServiceCatalogEntityId] = None,
    pathId: Option[ServiceCatalogEntityId] = None,
    provisioningParameters: Option[
      Iterable[zio.aws.sagemaker.model.ProvisioningParameter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisioningDetails = {
    import ServiceCatalogProvisioningDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisioningDetails
      .builder()
      .productId(ServiceCatalogEntityId.unwrap(productId): java.lang.String)
      .optionallyWith(
        provisioningArtifactId.map(value =>
          ServiceCatalogEntityId.unwrap(value): java.lang.String
        )
      )(_.provisioningArtifactId)
      .optionallyWith(
        pathId.map(value =>
          ServiceCatalogEntityId.unwrap(value): java.lang.String
        )
      )(_.pathId)
      .optionallyWith(
        provisioningParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly =
    zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails
      .wrap(buildAwsValue())
}
object ServiceCatalogProvisioningDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisioningDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails =
      zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails(
        productId,
        provisioningArtifactId.map(value => value),
        pathId.map(value => value),
        provisioningParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def productId: ServiceCatalogEntityId
    def provisioningArtifactId: Option[ServiceCatalogEntityId]
    def pathId: Option[ServiceCatalogEntityId]
    def provisioningParameters
        : Option[List[zio.aws.sagemaker.model.ProvisioningParameter.ReadOnly]]
    def getProductId: ZIO[Any, Nothing, ServiceCatalogEntityId] =
      ZIO.succeed(productId)
    def getProvisioningArtifactId: ZIO[Any, AwsError, ServiceCatalogEntityId] =
      AwsError.unwrapOptionField(
        "provisioningArtifactId",
        provisioningArtifactId
      )
    def getPathId: ZIO[Any, AwsError, ServiceCatalogEntityId] =
      AwsError.unwrapOptionField("pathId", pathId)
    def getProvisioningParameters: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProvisioningParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningParameters",
      provisioningParameters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisioningDetails
  ) extends zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly {
    override val productId: ServiceCatalogEntityId =
      zio.aws.sagemaker.model.primitives
        .ServiceCatalogEntityId(impl.productId())
    override val provisioningArtifactId: Option[ServiceCatalogEntityId] = scala
      .Option(impl.provisioningArtifactId())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ServiceCatalogEntityId(value)
      )
    override val pathId: Option[ServiceCatalogEntityId] = scala
      .Option(impl.pathId())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ServiceCatalogEntityId(value)
      )
    override val provisioningParameters
        : Option[List[zio.aws.sagemaker.model.ProvisioningParameter.ReadOnly]] =
      scala
        .Option(impl.provisioningParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ProvisioningParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisioningDetails
  ): zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly =
    new Wrapper(impl)
}
