package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  ProcessingJobArn,
  Timestamp,
  FailureReason,
  ExitMessage,
  ProcessingJobName
}
import scala.jdk.CollectionConverters._
final case class ProcessingJobSummary(
    processingJobName: ProcessingJobName,
    processingJobArn: ProcessingJobArn,
    creationTime: Timestamp,
    processingEndTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    processingJobStatus: zio.aws.sagemaker.model.ProcessingJobStatus,
    failureReason: Option[FailureReason] = None,
    exitMessage: Option[ExitMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProcessingJobSummary = {
    import ProcessingJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProcessingJobSummary
      .builder()
      .processingJobName(
        ProcessingJobName.unwrap(processingJobName): java.lang.String
      )
      .processingJobArn(
        ProcessingJobArn.unwrap(processingJobArn): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        processingEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.processingEndTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .processingJobStatus(processingJobStatus.unwrap)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        exitMessage.map(value => ExitMessage.unwrap(value): java.lang.String)
      )(_.exitMessage)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProcessingJobSummary.ReadOnly =
    zio.aws.sagemaker.model.ProcessingJobSummary.wrap(buildAwsValue())
}
object ProcessingJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProcessingJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProcessingJobSummary =
      zio.aws.sagemaker.model.ProcessingJobSummary(
        processingJobName,
        processingJobArn,
        creationTime,
        processingEndTime.map(value => value),
        lastModifiedTime.map(value => value),
        processingJobStatus,
        failureReason.map(value => value),
        exitMessage.map(value => value)
      )
    def processingJobName: ProcessingJobName
    def processingJobArn: ProcessingJobArn
    def creationTime: Timestamp
    def processingEndTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def processingJobStatus: zio.aws.sagemaker.model.ProcessingJobStatus
    def failureReason: Option[FailureReason]
    def exitMessage: Option[ExitMessage]
    def getProcessingJobName: ZIO[Any, Nothing, ProcessingJobName] =
      ZIO.succeed(processingJobName)
    def getProcessingJobArn: ZIO[Any, Nothing, ProcessingJobArn] =
      ZIO.succeed(processingJobArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getProcessingEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("processingEndTime", processingEndTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getProcessingJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ProcessingJobStatus] =
      ZIO.succeed(processingJobStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getExitMessage: ZIO[Any, AwsError, ExitMessage] =
      AwsError.unwrapOptionField("exitMessage", exitMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingJobSummary
  ) extends zio.aws.sagemaker.model.ProcessingJobSummary.ReadOnly {
    override val processingJobName: ProcessingJobName =
      zio.aws.sagemaker.model.primitives
        .ProcessingJobName(impl.processingJobName())
    override val processingJobArn: ProcessingJobArn =
      zio.aws.sagemaker.model.primitives
        .ProcessingJobArn(impl.processingJobArn())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val processingEndTime: Option[Timestamp] = scala
      .Option(impl.processingEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val processingJobStatus
        : zio.aws.sagemaker.model.ProcessingJobStatus =
      zio.aws.sagemaker.model.ProcessingJobStatus
        .wrap(impl.processingJobStatus())
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val exitMessage: Option[ExitMessage] = scala
      .Option(impl.exitMessage())
      .map(value => zio.aws.sagemaker.model.primitives.ExitMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingJobSummary
  ): zio.aws.sagemaker.model.ProcessingJobSummary.ReadOnly = new Wrapper(impl)
}
