package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OnlineStoreConfig(
    securityConfig: Option[zio.aws.sagemaker.model.OnlineStoreSecurityConfig] =
      None,
    enableOnlineStore: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfig = {
    import OnlineStoreConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfig
      .builder()
      .optionallyWith(securityConfig.map(value => value.buildAwsValue()))(
        _.securityConfig
      )
      .optionallyWith(enableOnlineStore.map(value => value: java.lang.Boolean))(
        _.enableOnlineStore
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly =
    zio.aws.sagemaker.model.OnlineStoreConfig.wrap(buildAwsValue())
}
object OnlineStoreConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.OnlineStoreConfig =
      zio.aws.sagemaker.model.OnlineStoreConfig(
        securityConfig.map(value => value.asEditable),
        enableOnlineStore.map(value => value)
      )
    def securityConfig
        : Option[zio.aws.sagemaker.model.OnlineStoreSecurityConfig.ReadOnly]
    def enableOnlineStore: Option[Boolean]
    def getSecurityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OnlineStoreSecurityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("securityConfig", securityConfig)
    def getEnableOnlineStore: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableOnlineStore", enableOnlineStore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfig
  ) extends zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly {
    override val securityConfig
        : Option[zio.aws.sagemaker.model.OnlineStoreSecurityConfig.ReadOnly] =
      scala
        .Option(impl.securityConfig())
        .map(value =>
          zio.aws.sagemaker.model.OnlineStoreSecurityConfig.wrap(value)
        )
    override val enableOnlineStore: Option[Boolean] =
      scala.Option(impl.enableOnlineStore()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfig
  ): zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly = new Wrapper(impl)
}
