package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ModelPackageSortBy {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ModelPackageSortBy
}
object ModelPackageSortBy {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelPackageSortBy
  ): zio.aws.sagemaker.model.ModelPackageSortBy = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageSortBy.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageSortBy.CREATION_TIME =>
      val r = CreationTime
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelPackageSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageSortBy =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object Name extends zio.aws.sagemaker.model.ModelPackageSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageSortBy =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageSortBy.NAME
  }
  case object CreationTime extends zio.aws.sagemaker.model.ModelPackageSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageSortBy =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageSortBy.CREATION_TIME
  }
}
