package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.EndpointName
import scala.jdk.CollectionConverters._
final case class ModelDeployResult(endpointName: Option[EndpointName] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelDeployResult = {
    import ModelDeployResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelDeployResult
      .builder()
      .optionallyWith(
        endpointName.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.endpointName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelDeployResult.ReadOnly =
    zio.aws.sagemaker.model.ModelDeployResult.wrap(buildAwsValue())
}
object ModelDeployResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelDeployResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelDeployResult =
      zio.aws.sagemaker.model
        .ModelDeployResult(endpointName.map(value => value))
    def endpointName: Option[EndpointName]
    def getEndpointName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("endpointName", endpointName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDeployResult
  ) extends zio.aws.sagemaker.model.ModelDeployResult.ReadOnly {
    override val endpointName: Option[EndpointName] = scala
      .Option(impl.endpointName())
      .map(value => zio.aws.sagemaker.model.primitives.EndpointName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDeployResult
  ): zio.aws.sagemaker.model.ModelDeployResult.ReadOnly = new Wrapper(impl)
}
