package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  JobReferenceCodeContains,
  WorkteamArn,
  Timestamp,
  MaxResults
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListLabelingJobsForWorkteamRequest(
    workteamArn: WorkteamArn,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    creationTimeAfter: Option[Timestamp] = None,
    creationTimeBefore: Option[Timestamp] = None,
    jobReferenceCodeContains: Option[JobReferenceCodeContains] = None,
    sortBy: Option[
      zio.aws.sagemaker.model.ListLabelingJobsForWorkteamSortByOptions
    ] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest = {
    import ListLabelingJobsForWorkteamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest
      .builder()
      .workteamArn(WorkteamArn.unwrap(workteamArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        jobReferenceCodeContains.map(value =>
          JobReferenceCodeContains.unwrap(value): java.lang.String
        )
      )(_.jobReferenceCodeContains)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListLabelingJobsForWorkteamRequest.ReadOnly =
    zio.aws.sagemaker.model.ListLabelingJobsForWorkteamRequest
      .wrap(buildAwsValue())
}
object ListLabelingJobsForWorkteamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListLabelingJobsForWorkteamRequest =
      zio.aws.sagemaker.model.ListLabelingJobsForWorkteamRequest(
        workteamArn,
        maxResults.map(value => value),
        nextToken.map(value => value),
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        jobReferenceCodeContains.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def workteamArn: WorkteamArn
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def creationTimeAfter: Option[Timestamp]
    def creationTimeBefore: Option[Timestamp]
    def jobReferenceCodeContains: Option[JobReferenceCodeContains]
    def sortBy: Option[
      zio.aws.sagemaker.model.ListLabelingJobsForWorkteamSortByOptions
    ]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def getWorkteamArn: ZIO[Any, Nothing, WorkteamArn] =
      ZIO.succeed(workteamArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getJobReferenceCodeContains
        : ZIO[Any, AwsError, JobReferenceCodeContains] = AwsError
      .unwrapOptionField("jobReferenceCodeContains", jobReferenceCodeContains)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ListLabelingJobsForWorkteamSortByOptions
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest
  ) extends zio.aws.sagemaker.model.ListLabelingJobsForWorkteamRequest.ReadOnly {
    override val workteamArn: WorkteamArn =
      zio.aws.sagemaker.model.primitives.WorkteamArn(impl.workteamArn())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val creationTimeAfter: Option[Timestamp] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeBefore: Option[Timestamp] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val jobReferenceCodeContains: Option[JobReferenceCodeContains] =
      scala
        .Option(impl.jobReferenceCodeContains())
        .map(value =>
          zio.aws.sagemaker.model.primitives.JobReferenceCodeContains(value)
        )
    override val sortBy: Option[
      zio.aws.sagemaker.model.ListLabelingJobsForWorkteamSortByOptions
    ] = scala
      .Option(impl.sortBy())
      .map(value =>
        zio.aws.sagemaker.model.ListLabelingJobsForWorkteamSortByOptions
          .wrap(value)
      )
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest
  ): zio.aws.sagemaker.model.ListLabelingJobsForWorkteamRequest.ReadOnly =
    new Wrapper(impl)
}
