package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListCompilationJobsResponse(
    compilationJobSummaries: Iterable[
      zio.aws.sagemaker.model.CompilationJobSummary
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse = {
    import ListCompilationJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse
      .builder()
      .compilationJobSummaries(compilationJobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListCompilationJobsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListCompilationJobsResponse.wrap(buildAwsValue())
}
object ListCompilationJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListCompilationJobsResponse =
      zio.aws.sagemaker.model.ListCompilationJobsResponse(
        compilationJobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def compilationJobSummaries
        : List[zio.aws.sagemaker.model.CompilationJobSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getCompilationJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.CompilationJobSummary.ReadOnly
    ]] = ZIO.succeed(compilationJobSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse
  ) extends zio.aws.sagemaker.model.ListCompilationJobsResponse.ReadOnly {
    override val compilationJobSummaries
        : List[zio.aws.sagemaker.model.CompilationJobSummary.ReadOnly] = impl
      .compilationJobSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.CompilationJobSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse
  ): zio.aws.sagemaker.model.ListCompilationJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
