package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  ModelArn,
  LabelingJobAlgorithmSpecificationArn
}
import scala.jdk.CollectionConverters._
final case class LabelingJobAlgorithmsConfig(
    labelingJobAlgorithmSpecificationArn: LabelingJobAlgorithmSpecificationArn,
    initialActiveLearningModelArn: Option[ModelArn] = None,
    labelingJobResourceConfig: Option[
      zio.aws.sagemaker.model.LabelingJobResourceConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelingJobAlgorithmsConfig = {
    import LabelingJobAlgorithmsConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelingJobAlgorithmsConfig
      .builder()
      .labelingJobAlgorithmSpecificationArn(
        LabelingJobAlgorithmSpecificationArn.unwrap(
          labelingJobAlgorithmSpecificationArn
        ): java.lang.String
      )
      .optionallyWith(
        initialActiveLearningModelArn.map(value =>
          ModelArn.unwrap(value): java.lang.String
        )
      )(_.initialActiveLearningModelArn)
      .optionallyWith(
        labelingJobResourceConfig.map(value => value.buildAwsValue())
      )(_.labelingJobResourceConfig)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig.ReadOnly =
    zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig.wrap(buildAwsValue())
}
object LabelingJobAlgorithmsConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelingJobAlgorithmsConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig =
      zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig(
        labelingJobAlgorithmSpecificationArn,
        initialActiveLearningModelArn.map(value => value),
        labelingJobResourceConfig.map(value => value.asEditable)
      )
    def labelingJobAlgorithmSpecificationArn
        : LabelingJobAlgorithmSpecificationArn
    def initialActiveLearningModelArn: Option[ModelArn]
    def labelingJobResourceConfig
        : Option[zio.aws.sagemaker.model.LabelingJobResourceConfig.ReadOnly]
    def getLabelingJobAlgorithmSpecificationArn
        : ZIO[Any, Nothing, LabelingJobAlgorithmSpecificationArn] =
      ZIO.succeed(labelingJobAlgorithmSpecificationArn)
    def getInitialActiveLearningModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField(
        "initialActiveLearningModelArn",
        initialActiveLearningModelArn
      )
    def getLabelingJobResourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelingJobResourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "labelingJobResourceConfig",
      labelingJobResourceConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobAlgorithmsConfig
  ) extends zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig.ReadOnly {
    override val labelingJobAlgorithmSpecificationArn
        : LabelingJobAlgorithmSpecificationArn =
      zio.aws.sagemaker.model.primitives.LabelingJobAlgorithmSpecificationArn(
        impl.labelingJobAlgorithmSpecificationArn()
      )
    override val initialActiveLearningModelArn: Option[ModelArn] = scala
      .Option(impl.initialActiveLearningModelArn())
      .map(value => zio.aws.sagemaker.model.primitives.ModelArn(value))
    override val labelingJobResourceConfig
        : Option[zio.aws.sagemaker.model.LabelingJobResourceConfig.ReadOnly] =
      scala
        .Option(impl.labelingJobResourceConfig())
        .map(value =>
          zio.aws.sagemaker.model.LabelingJobResourceConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobAlgorithmsConfig
  ): zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig.ReadOnly = new Wrapper(
    impl
  )
}
