package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{TagKey, ResourceArn}
import scala.jdk.CollectionConverters._
final case class DeleteTagsRequest(
    resourceArn: ResourceArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest = {
    import DeleteTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteTagsRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteTagsRequest.wrap(buildAwsValue())
}
object DeleteTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteTagsRequest =
      zio.aws.sagemaker.model.DeleteTagsRequest(resourceArn, tagKeys)
    def resourceArn: ResourceArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest
  ) extends zio.aws.sagemaker.model.DeleteTagsRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.sagemaker.model.primitives.ResourceArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest
  ): zio.aws.sagemaker.model.DeleteTagsRequest.ReadOnly = new Wrapper(impl)
}
