package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  S3Uri,
  ProcessingEnvironmentValue,
  ProcessingEnvironmentKey,
  ContainerArgument,
  ContainerEntrypointString,
  ImageUri
}
import scala.jdk.CollectionConverters._
final case class DataQualityAppSpecification(
    imageUri: ImageUri,
    containerEntrypoint: Option[Iterable[ContainerEntrypointString]] = None,
    containerArguments: Option[Iterable[ContainerArgument]] = None,
    recordPreprocessorSourceUri: Option[S3Uri] = None,
    postAnalyticsProcessorSourceUri: Option[S3Uri] = None,
    environment: Option[
      Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DataQualityAppSpecification = {
    import DataQualityAppSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DataQualityAppSpecification
      .builder()
      .imageUri(ImageUri.unwrap(imageUri): java.lang.String)
      .optionallyWith(
        containerEntrypoint.map(value =>
          value.map { item =>
            ContainerEntrypointString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.containerEntrypoint)
      .optionallyWith(
        containerArguments.map(value =>
          value.map { item =>
            ContainerArgument.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.containerArguments)
      .optionallyWith(
        recordPreprocessorSourceUri.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.recordPreprocessorSourceUri)
      .optionallyWith(
        postAnalyticsProcessorSourceUri.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.postAnalyticsProcessorSourceUri)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (ProcessingEnvironmentKey
                .unwrap(key): java.lang.String) -> (ProcessingEnvironmentValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DataQualityAppSpecification.ReadOnly =
    zio.aws.sagemaker.model.DataQualityAppSpecification.wrap(buildAwsValue())
}
object DataQualityAppSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DataQualityAppSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DataQualityAppSpecification =
      zio.aws.sagemaker.model.DataQualityAppSpecification(
        imageUri,
        containerEntrypoint.map(value => value),
        containerArguments.map(value => value),
        recordPreprocessorSourceUri.map(value => value),
        postAnalyticsProcessorSourceUri.map(value => value),
        environment.map(value => value)
      )
    def imageUri: ImageUri
    def containerEntrypoint: Option[List[ContainerEntrypointString]]
    def containerArguments: Option[List[ContainerArgument]]
    def recordPreprocessorSourceUri: Option[S3Uri]
    def postAnalyticsProcessorSourceUri: Option[S3Uri]
    def environment
        : Option[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]]
    def getImageUri: ZIO[Any, Nothing, ImageUri] = ZIO.succeed(imageUri)
    def getContainerEntrypoint
        : ZIO[Any, AwsError, List[ContainerEntrypointString]] =
      AwsError.unwrapOptionField("containerEntrypoint", containerEntrypoint)
    def getContainerArguments: ZIO[Any, AwsError, List[ContainerArgument]] =
      AwsError.unwrapOptionField("containerArguments", containerArguments)
    def getRecordPreprocessorSourceUri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField(
        "recordPreprocessorSourceUri",
        recordPreprocessorSourceUri
      )
    def getPostAnalyticsProcessorSourceUri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField(
        "postAnalyticsProcessorSourceUri",
        postAnalyticsProcessorSourceUri
      )
    def getEnvironment: ZIO[Any, AwsError, Map[
      ProcessingEnvironmentKey,
      ProcessingEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DataQualityAppSpecification
  ) extends zio.aws.sagemaker.model.DataQualityAppSpecification.ReadOnly {
    override val imageUri: ImageUri =
      zio.aws.sagemaker.model.primitives.ImageUri(impl.imageUri())
    override val containerEntrypoint: Option[List[ContainerEntrypointString]] =
      scala
        .Option(impl.containerEntrypoint())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.ContainerEntrypointString(item)
          }.toList
        )
    override val containerArguments: Option[List[ContainerArgument]] = scala
      .Option(impl.containerArguments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.ContainerArgument(item)
        }.toList
      )
    override val recordPreprocessorSourceUri: Option[S3Uri] = scala
      .Option(impl.recordPreprocessorSourceUri())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val postAnalyticsProcessorSourceUri: Option[S3Uri] = scala
      .Option(impl.postAnalyticsProcessorSourceUri())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val environment
        : Option[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]] =
      scala
        .Option(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.ProcessingEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .ProcessingEnvironmentValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DataQualityAppSpecification
  ): zio.aws.sagemaker.model.DataQualityAppSpecification.ReadOnly = new Wrapper(
    impl
  )
}
