package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AutoMLJobStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus
}
object AutoMLJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus
  ): zio.aws.sagemaker.model.AutoMLJobStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus.STOPPING =>
      val r = Stopping
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AutoMLJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Completed extends zio.aws.sagemaker.model.AutoMLJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus.COMPLETED
  }
  case object InProgress extends zio.aws.sagemaker.model.AutoMLJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus.IN_PROGRESS
  }
  case object Failed extends zio.aws.sagemaker.model.AutoMLJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus.FAILED
  }
  case object Stopped extends zio.aws.sagemaker.model.AutoMLJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus.STOPPED
  }
  case object Stopping extends zio.aws.sagemaker.model.AutoMLJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus.STOPPING
  }
}
