package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AutoMLJobSecondaryStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus
}
object AutoMLJobSecondaryStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus
  ): zio.aws.sagemaker.model.AutoMLJobSecondaryStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.STARTING =>
      val r = Starting
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.ANALYZING_DATA =>
      val r = AnalyzingData
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.FEATURE_ENGINEERING =>
      val r = FeatureEngineering
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.MODEL_TUNING =>
      val r = ModelTuning
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.MAX_CANDIDATES_REACHED =>
      val r = MaxCandidatesReached
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.MAX_AUTO_ML_JOB_RUNTIME_REACHED =>
      val r = MaxAutoMLJobRuntimeReached
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.CANDIDATE_DEFINITIONS_GENERATED =>
      val r = CandidateDefinitionsGenerated
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.GENERATING_EXPLAINABILITY_REPORT =>
      val r = GeneratingExplainabilityReport
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.EXPLAINABILITY_ERROR =>
      val r = ExplainabilityError
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.DEPLOYING_MODEL =>
      val r = DeployingModel
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.MODEL_DEPLOYMENT_ERROR =>
      val r = ModelDeploymentError
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Starting
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.STARTING
  }
  case object AnalyzingData
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.ANALYZING_DATA
  }
  case object FeatureEngineering
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.FEATURE_ENGINEERING
  }
  case object ModelTuning
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.MODEL_TUNING
  }
  case object MaxCandidatesReached
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.MAX_CANDIDATES_REACHED
  }
  case object Failed extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.FAILED
  }
  case object Stopped extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.STOPPED
  }
  case object MaxAutoMLJobRuntimeReached
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.MAX_AUTO_ML_JOB_RUNTIME_REACHED
  }
  case object Stopping
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.STOPPING
  }
  case object CandidateDefinitionsGenerated
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.CANDIDATE_DEFINITIONS_GENERATED
  }
  case object GeneratingExplainabilityReport
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.GENERATING_EXPLAINABILITY_REPORT
  }
  case object Completed
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.COMPLETED
  }
  case object ExplainabilityError
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.EXPLAINABILITY_ERROR
  }
  case object DeployingModel
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.DEPLOYING_MODEL
  }
  case object ModelDeploymentError
      extends zio.aws.sagemaker.model.AutoMLJobSecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus.MODEL_DEPLOYMENT_ERROR
  }
}
