package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AppType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AppType
}
object AppType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AppType
  ): zio.aws.sagemaker.model.AppType = value match {
    case software.amazon.awssdk.services.sagemaker.model.AppType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AppType.JUPYTER_SERVER =>
      val r = JupyterServer
      r
    case software.amazon.awssdk.services.sagemaker.model.AppType.KERNEL_GATEWAY =>
      val r = KernelGateway
      r
    case software.amazon.awssdk.services.sagemaker.model.AppType.TENSOR_BOARD =>
      val r = TensorBoard
      r
    case software.amazon.awssdk.services.sagemaker.model.AppType.R_STUDIO_SERVER_PRO =>
      val r = RStudioServerPro
      r
    case software.amazon.awssdk.services.sagemaker.model.AppType.R_SESSION_GATEWAY =>
      val r = RSessionGateway
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.AppType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppType =
      software.amazon.awssdk.services.sagemaker.model.AppType.UNKNOWN_TO_SDK_VERSION
  }
  case object JupyterServer extends zio.aws.sagemaker.model.AppType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppType =
      software.amazon.awssdk.services.sagemaker.model.AppType.JUPYTER_SERVER
  }
  case object KernelGateway extends zio.aws.sagemaker.model.AppType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppType =
      software.amazon.awssdk.services.sagemaker.model.AppType.KERNEL_GATEWAY
  }
  case object TensorBoard extends zio.aws.sagemaker.model.AppType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppType =
      software.amazon.awssdk.services.sagemaker.model.AppType.TENSOR_BOARD
  }
  case object RStudioServerPro extends zio.aws.sagemaker.model.AppType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppType =
      software.amazon.awssdk.services.sagemaker.model.AppType.R_STUDIO_SERVER_PRO
  }
  case object RSessionGateway extends zio.aws.sagemaker.model.AppType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppType =
      software.amazon.awssdk.services.sagemaker.model.AppType.R_SESSION_GATEWAY
  }
}
