package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VersioningConfiguration(
    mfaDelete: Optional[zio.aws.s3control.model.MFADelete] = Optional.Absent,
    status: Optional[zio.aws.s3control.model.BucketVersioningStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.VersioningConfiguration = {
    import VersioningConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.VersioningConfiguration
      .builder()
      .optionallyWith(mfaDelete.map(value => value.unwrap))(_.mfaDelete)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.VersioningConfiguration.ReadOnly =
    zio.aws.s3control.model.VersioningConfiguration.wrap(buildAwsValue())
}
object VersioningConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.VersioningConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.VersioningConfiguration =
      zio.aws.s3control.model.VersioningConfiguration(
        mfaDelete.map(value => value),
        status.map(value => value)
      )
    def mfaDelete: Optional[zio.aws.s3control.model.MFADelete]
    def status: Optional[zio.aws.s3control.model.BucketVersioningStatus]
    def getMfaDelete: ZIO[Any, AwsError, zio.aws.s3control.model.MFADelete] =
      AwsError.unwrapOptionField("mfaDelete", mfaDelete)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.s3control.model.BucketVersioningStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.VersioningConfiguration
  ) extends zio.aws.s3control.model.VersioningConfiguration.ReadOnly {
    override val mfaDelete: Optional[zio.aws.s3control.model.MFADelete] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mfaDelete())
        .map(value => zio.aws.s3control.model.MFADelete.wrap(value))
    override val status
        : Optional[zio.aws.s3control.model.BucketVersioningStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.s3control.model.BucketVersioningStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.VersioningConfiguration
  ): zio.aws.s3control.model.VersioningConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
