package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceSelectionCriteria(
    sseKmsEncryptedObjects: Optional[
      zio.aws.s3control.model.SseKmsEncryptedObjects
    ] = Optional.Absent,
    replicaModifications: Optional[
      zio.aws.s3control.model.ReplicaModifications
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.SourceSelectionCriteria = {
    import SourceSelectionCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.SourceSelectionCriteria
      .builder()
      .optionallyWith(
        sseKmsEncryptedObjects.map(value => value.buildAwsValue())
      )(_.sseKmsEncryptedObjects)
      .optionallyWith(replicaModifications.map(value => value.buildAwsValue()))(
        _.replicaModifications
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.SourceSelectionCriteria.ReadOnly =
    zio.aws.s3control.model.SourceSelectionCriteria.wrap(buildAwsValue())
}
object SourceSelectionCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.SourceSelectionCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.SourceSelectionCriteria =
      zio.aws.s3control.model.SourceSelectionCriteria(
        sseKmsEncryptedObjects.map(value => value.asEditable),
        replicaModifications.map(value => value.asEditable)
      )
    def sseKmsEncryptedObjects
        : Optional[zio.aws.s3control.model.SseKmsEncryptedObjects.ReadOnly]
    def replicaModifications
        : Optional[zio.aws.s3control.model.ReplicaModifications.ReadOnly]
    def getSseKmsEncryptedObjects: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.SseKmsEncryptedObjects.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sseKmsEncryptedObjects",
      sseKmsEncryptedObjects
    )
    def getReplicaModifications: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.ReplicaModifications.ReadOnly
    ] = AwsError.unwrapOptionField("replicaModifications", replicaModifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.SourceSelectionCriteria
  ) extends zio.aws.s3control.model.SourceSelectionCriteria.ReadOnly {
    override val sseKmsEncryptedObjects
        : Optional[zio.aws.s3control.model.SseKmsEncryptedObjects.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseKmsEncryptedObjects())
        .map(value =>
          zio.aws.s3control.model.SseKmsEncryptedObjects.wrap(value)
        )
    override val replicaModifications
        : Optional[zio.aws.s3control.model.ReplicaModifications.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaModifications())
        .map(value => zio.aws.s3control.model.ReplicaModifications.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.SourceSelectionCriteria
  ): zio.aws.s3control.model.SourceSelectionCriteria.ReadOnly = new Wrapper(
    impl
  )
}
