package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class S3ObjectLockLegalHold(
    status: zio.aws.s3control.model.S3ObjectLockLegalHoldStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHold = {
    import S3ObjectLockLegalHold.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHold
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3ObjectLockLegalHold.ReadOnly =
    zio.aws.s3control.model.S3ObjectLockLegalHold.wrap(buildAwsValue())
}
object S3ObjectLockLegalHold {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHold
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3ObjectLockLegalHold =
      zio.aws.s3control.model.S3ObjectLockLegalHold(status)
    def status: zio.aws.s3control.model.S3ObjectLockLegalHoldStatus
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.S3ObjectLockLegalHoldStatus
    ] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHold
  ) extends zio.aws.s3control.model.S3ObjectLockLegalHold.ReadOnly {
    override val status: zio.aws.s3control.model.S3ObjectLockLegalHoldStatus =
      zio.aws.s3control.model.S3ObjectLockLegalHoldStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHold
  ): zio.aws.s3control.model.S3ObjectLockLegalHold.ReadOnly = new Wrapper(impl)
}
