package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait ReplicationRuleStatus {
  def unwrap
      : software.amazon.awssdk.services.s3control.model.ReplicationRuleStatus
}
object ReplicationRuleStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.ReplicationRuleStatus
  ): zio.aws.s3control.model.ReplicationRuleStatus = value match {
    case software.amazon.awssdk.services.s3control.model.ReplicationRuleStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationRuleStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationRuleStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.ReplicationRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationRuleStatus =
      software.amazon.awssdk.services.s3control.model.ReplicationRuleStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.s3control.model.ReplicationRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationRuleStatus =
      software.amazon.awssdk.services.s3control.model.ReplicationRuleStatus.ENABLED
  }
  case object Disabled extends zio.aws.s3control.model.ReplicationRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationRuleStatus =
      software.amazon.awssdk.services.s3control.model.ReplicationRuleStatus.DISABLED
  }
}
