package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  BucketIdentifierString,
  Prefix,
  Priority,
  ID
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ReplicationRule(
    id: Optional[ID] = Optional.Absent,
    priority: Optional[Priority] = Optional.Absent,
    prefix: Optional[Prefix] = Optional.Absent,
    filter: Optional[zio.aws.s3control.model.ReplicationRuleFilter] =
      Optional.Absent,
    status: zio.aws.s3control.model.ReplicationRuleStatus,
    sourceSelectionCriteria: Optional[
      zio.aws.s3control.model.SourceSelectionCriteria
    ] = Optional.Absent,
    existingObjectReplication: Optional[
      zio.aws.s3control.model.ExistingObjectReplication
    ] = Optional.Absent,
    destination: zio.aws.s3control.model.Destination,
    deleteMarkerReplication: Optional[
      zio.aws.s3control.model.DeleteMarkerReplication
    ] = Optional.Absent,
    bucket: BucketIdentifierString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ReplicationRule = {
    import ReplicationRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ReplicationRule
      .builder()
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(priority.map(value => Priority.unwrap(value): Integer))(
        _.priority
      )
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .status(status.unwrap)
      .optionallyWith(
        sourceSelectionCriteria.map(value => value.buildAwsValue())
      )(_.sourceSelectionCriteria)
      .optionallyWith(
        existingObjectReplication.map(value => value.buildAwsValue())
      )(_.existingObjectReplication)
      .destination(destination.buildAwsValue())
      .optionallyWith(
        deleteMarkerReplication.map(value => value.buildAwsValue())
      )(_.deleteMarkerReplication)
      .bucket(BucketIdentifierString.unwrap(bucket): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ReplicationRule.ReadOnly =
    zio.aws.s3control.model.ReplicationRule.wrap(buildAwsValue())
}
object ReplicationRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ReplicationRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ReplicationRule =
      zio.aws.s3control.model.ReplicationRule(
        id.map(value => value),
        priority.map(value => value),
        prefix.map(value => value),
        filter.map(value => value.asEditable),
        status,
        sourceSelectionCriteria.map(value => value.asEditable),
        existingObjectReplication.map(value => value.asEditable),
        destination.asEditable,
        deleteMarkerReplication.map(value => value.asEditable),
        bucket
      )
    def id: Optional[ID]
    def priority: Optional[Priority]
    def prefix: Optional[Prefix]
    def filter: Optional[zio.aws.s3control.model.ReplicationRuleFilter.ReadOnly]
    def status: zio.aws.s3control.model.ReplicationRuleStatus
    def sourceSelectionCriteria
        : Optional[zio.aws.s3control.model.SourceSelectionCriteria.ReadOnly]
    def existingObjectReplication
        : Optional[zio.aws.s3control.model.ExistingObjectReplication.ReadOnly]
    def destination: zio.aws.s3control.model.Destination.ReadOnly
    def deleteMarkerReplication
        : Optional[zio.aws.s3control.model.DeleteMarkerReplication.ReadOnly]
    def bucket: BucketIdentifierString
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getPriority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priority)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.ReplicationRuleFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.s3control.model.ReplicationRuleStatus] =
      ZIO.succeed(status)
    def getSourceSelectionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.SourceSelectionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceSelectionCriteria",
      sourceSelectionCriteria
    )
    def getExistingObjectReplication: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.ExistingObjectReplication.ReadOnly
    ] = AwsError.unwrapOptionField(
      "existingObjectReplication",
      existingObjectReplication
    )
    def getDestination
        : ZIO[Any, Nothing, zio.aws.s3control.model.Destination.ReadOnly] =
      ZIO.succeed(destination)
    def getDeleteMarkerReplication: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.DeleteMarkerReplication.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deleteMarkerReplication",
      deleteMarkerReplication
    )
    def getBucket: ZIO[Any, Nothing, BucketIdentifierString] =
      ZIO.succeed(bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ReplicationRule
  ) extends zio.aws.s3control.model.ReplicationRule.ReadOnly {
    override val id: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.s3control.model.primitives.ID(value))
    override val priority: Optional[Priority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.s3control.model.primitives.Priority(value))
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3control.model.primitives.Prefix(value))
    override val filter
        : Optional[zio.aws.s3control.model.ReplicationRuleFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.s3control.model.ReplicationRuleFilter.wrap(value))
    override val status: zio.aws.s3control.model.ReplicationRuleStatus =
      zio.aws.s3control.model.ReplicationRuleStatus.wrap(impl.status())
    override val sourceSelectionCriteria
        : Optional[zio.aws.s3control.model.SourceSelectionCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceSelectionCriteria())
        .map(value =>
          zio.aws.s3control.model.SourceSelectionCriteria.wrap(value)
        )
    override val existingObjectReplication
        : Optional[zio.aws.s3control.model.ExistingObjectReplication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.existingObjectReplication())
        .map(value =>
          zio.aws.s3control.model.ExistingObjectReplication.wrap(value)
        )
    override val destination: zio.aws.s3control.model.Destination.ReadOnly =
      zio.aws.s3control.model.Destination.wrap(impl.destination())
    override val deleteMarkerReplication
        : Optional[zio.aws.s3control.model.DeleteMarkerReplication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteMarkerReplication())
        .map(value =>
          zio.aws.s3control.model.DeleteMarkerReplication.wrap(value)
        )
    override val bucket: BucketIdentifierString =
      zio.aws.s3control.model.primitives.BucketIdentifierString(impl.bucket())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ReplicationRule
  ): zio.aws.s3control.model.ReplicationRule.ReadOnly = new Wrapper(impl)
}
