package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ReplicaModifications(
    status: zio.aws.s3control.model.ReplicaModificationsStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ReplicaModifications = {
    import ReplicaModifications.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ReplicaModifications
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ReplicaModifications.ReadOnly =
    zio.aws.s3control.model.ReplicaModifications.wrap(buildAwsValue())
}
object ReplicaModifications {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ReplicaModifications
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ReplicaModifications =
      zio.aws.s3control.model.ReplicaModifications(status)
    def status: zio.aws.s3control.model.ReplicaModificationsStatus
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.ReplicaModificationsStatus
    ] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ReplicaModifications
  ) extends zio.aws.s3control.model.ReplicaModifications.ReadOnly {
    override val status: zio.aws.s3control.model.ReplicaModificationsStatus =
      zio.aws.s3control.model.ReplicaModificationsStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ReplicaModifications
  ): zio.aws.s3control.model.ReplicaModifications.ReadOnly = new Wrapper(impl)
}
